/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lineage.sink;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.openlineage.client.OpenLineageClient;
import io.openlineage.client.transports.HttpConfig;
import io.openlineage.client.transports.HttpTransport;
import io.openlineage.client.transports.Transport;
import io.openlineage.server.OpenLineage;
import java.util.Map;
import org.apache.gravitino.lineage.Utils;
import org.apache.gravitino.lineage.auth.AuthenticationFactory;
import org.apache.gravitino.lineage.auth.LineageServerAuthenticationStrategy;
import org.apache.gravitino.lineage.sink.LineageSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageHttpSink
implements LineageSink {
    private static final Logger LOG = LoggerFactory.getLogger(LineageHttpSink.class);
    private OpenLineageClient client;

    @Override
    public void initialize(Map<String, String> configs) {
        String httpSinkUrl = configs.getOrDefault("url", "http://localhost:5000/");
        String authType = configs.get("authType");
        LOG.info("Http sink URL: {}, authentication type: {}", (Object)httpSinkUrl, (Object)authType);
        LineageServerAuthenticationStrategy authStrategy = AuthenticationFactory.createStrategy(authType);
        HttpConfig httpConfig = authStrategy.configureHttpConfig(httpSinkUrl, configs);
        HttpTransport transport = new HttpTransport(httpConfig);
        this.client = OpenLineageClient.builder().transport((Transport)transport).build();
    }

    @Override
    public void sink(OpenLineage.RunEvent runEvent) {
        try {
            this.client.emit(Utils.getClientRunEvent(runEvent));
            LOG.info("Sent lineage event to http sink: {}", (Object)runEvent);
        }
        catch (JsonProcessingException e) {
            LOG.warn("Could not parse lineage run event", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

