/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.dataset.jni;

import java.io.IOException;
import org.apache.arrow.dataset.jni.JniWrapper;
import org.apache.arrow.dataset.jni.NativeContext;
import org.apache.arrow.dataset.jni.NativeDataset;
import org.apache.arrow.dataset.jni.NativeInstanceReleasedException;
import org.apache.arrow.dataset.jni.NativeMemoryPool;
import org.apache.arrow.dataset.source.DatasetFactory;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.SchemaUtility;

public class NativeDatasetFactory
implements DatasetFactory {
    private final long datasetFactoryId;
    private final NativeMemoryPool memoryPool;
    private final BufferAllocator allocator;
    private boolean closed = false;

    public NativeDatasetFactory(BufferAllocator allocator, NativeMemoryPool memoryPool, long datasetFactoryId) {
        this.allocator = allocator;
        this.memoryPool = memoryPool;
        this.datasetFactoryId = datasetFactoryId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema inspect() {
        byte[] buffer;
        NativeDatasetFactory nativeDatasetFactory = this;
        synchronized (nativeDatasetFactory) {
            if (this.closed) {
                throw new NativeInstanceReleasedException();
            }
            buffer = JniWrapper.get().inspectSchema(this.datasetFactoryId);
        }
        try {
            return SchemaUtility.deserialize((byte[])buffer, (BufferAllocator)this.allocator);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public NativeDataset finish() {
        return this.finish(this.inspect());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NativeDataset finish(Schema schema) {
        try {
            byte[] serialized = SchemaUtility.serialize((Schema)schema);
            NativeDatasetFactory nativeDatasetFactory = this;
            synchronized (nativeDatasetFactory) {
                if (this.closed) {
                    throw new NativeInstanceReleasedException();
                }
                return new NativeDataset(new NativeContext(this.allocator, this.memoryPool), JniWrapper.get().createDataset(this.datasetFactoryId, serialized));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        JniWrapper.get().closeDatasetFactory(this.datasetFactoryId);
    }
}

