/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.VariantLogicalType;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

abstract class AvroCustomOrderSchemaVisitor<T, F> {
    private static final String METADATA = "metadata";
    private static final String VALUE = "value";
    private final Deque<String> recordLevels = Lists.newLinkedList();

    AvroCustomOrderSchemaVisitor() {
    }

    public static <T, F> T visit(Schema schema, AvroCustomOrderSchemaVisitor<T, F> visitor) {
        switch (schema.getType()) {
            case RECORD: {
                String name = schema.getFullName();
                Preconditions.checkState((!visitor.recordLevels.contains(name) ? 1 : 0) != 0, (String)"Cannot process recursive Avro record %s", (Object)name);
                if (schema.getLogicalType() instanceof VariantLogicalType) {
                    Preconditions.checkArgument((boolean)AvroSchemaUtil.isVariantSchema(schema), (String)"Invalid variant record: %s", (Object)schema);
                    return visitor.variant(schema, new VisitFuture<T, F>(schema.getField(METADATA).schema(), visitor), new VisitFuture<T, F>(schema.getField(VALUE).schema(), visitor));
                }
                visitor.recordLevels.push(name);
                List fields = schema.getFields();
                ArrayList names = Lists.newArrayListWithExpectedSize((int)fields.size());
                ArrayList results = Lists.newArrayListWithExpectedSize((int)fields.size());
                for (Schema.Field field : schema.getFields()) {
                    names.add(field.name());
                    results.add(new VisitFieldFuture<T, F>(field, visitor));
                }
                visitor.recordLevels.pop();
                return visitor.record(schema, names, Iterables.transform((Iterable)results, Supplier::get));
            }
            case UNION: {
                List types = schema.getTypes();
                ArrayList options = Lists.newArrayListWithExpectedSize((int)types.size());
                for (Schema type : types) {
                    options.add(new VisitFuture<T, F>(type, visitor));
                }
                return visitor.union(schema, Iterables.transform((Iterable)options, Supplier::get));
            }
            case ARRAY: {
                return visitor.array(schema, new VisitFuture<T, F>(schema.getElementType(), visitor));
            }
            case MAP: {
                return visitor.map(schema, new VisitFuture<T, F>(schema.getValueType(), visitor));
            }
        }
        return visitor.primitive(schema);
    }

    public T record(Schema record, List<String> names, Iterable<F> fields) {
        return null;
    }

    public F field(Schema.Field field, Supplier<T> fieldResult) {
        return null;
    }

    public T union(Schema union, Iterable<T> options) {
        return null;
    }

    public T array(Schema array, Supplier<T> element) {
        return null;
    }

    public T map(Schema map, Supplier<T> value) {
        return null;
    }

    public T variant(Schema variant, Supplier<T> metadataResult, Supplier<T> valueResult) {
        throw new UnsupportedOperationException("Unsupported type: variant");
    }

    public T primitive(Schema primitive) {
        return null;
    }

    private static class VisitFieldFuture<T, F>
    implements Supplier<F> {
        private final Schema.Field field;
        private final AvroCustomOrderSchemaVisitor<T, F> visitor;

        private VisitFieldFuture(Schema.Field field, AvroCustomOrderSchemaVisitor<T, F> visitor) {
            this.field = field;
            this.visitor = visitor;
        }

        @Override
        public F get() {
            return this.visitor.field(this.field, new VisitFuture<T, F>(this.field.schema(), this.visitor));
        }
    }

    private static class VisitFuture<T, F>
    implements Supplier<T> {
        private final Schema schema;
        private final AvroCustomOrderSchemaVisitor<T, F> visitor;

        private VisitFuture(Schema schema, AvroCustomOrderSchemaVisitor<T, F> visitor) {
            this.schema = schema;
            this.visitor = visitor;
        }

        @Override
        public T get() {
            return AvroCustomOrderSchemaVisitor.visit(this.schema, this.visitor);
        }
    }
}

