/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.GenericEntity;
import org.apache.gravitino.meta.PolicyEntity;
import org.apache.gravitino.storage.relational.mapper.PolicyMetaMapper;
import org.apache.gravitino.storage.relational.mapper.PolicyMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.mapper.PolicyVersionMapper;
import org.apache.gravitino.storage.relational.po.PolicyMaxVersionPO;
import org.apache.gravitino.storage.relational.po.PolicyPO;
import org.apache.gravitino.storage.relational.service.MetadataObjectService;
import org.apache.gravitino.storage.relational.service.MetalakeMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.MetadataObjectUtil;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyMetaService {
    private static final PolicyMetaService INSTANCE = new PolicyMetaService();
    private static final Logger LOG = LoggerFactory.getLogger(PolicyMetaService.class);

    public static PolicyMetaService getInstance() {
        return INSTANCE;
    }

    private PolicyMetaService() {
    }

    public List<PolicyEntity> listPoliciesByNamespace(Namespace namespace) {
        String metalakeName = namespace.level(0);
        List policyPOs = SessionUtils.getWithoutCommit(PolicyMetaMapper.class, mapper -> mapper.listPolicyPOsByMetalake(metalakeName));
        return policyPOs.stream().map(policyPO -> POConverters.fromPolicyPO(policyPO, namespace)).collect(Collectors.toList());
    }

    public PolicyEntity getPolicyByIdentifier(NameIdentifier ident) {
        String metalakeName = ident.namespace().level(0);
        PolicyPO policyPO = this.getPolicyPOByMetalakeAndName(metalakeName, ident.name());
        return POConverters.fromPolicyPO(policyPO, ident.namespace());
    }

    public void insertPolicy(PolicyEntity policyEntity, boolean overwritten) throws IOException {
        Namespace ns = policyEntity.namespace();
        String metalakeName = ns.level(0);
        try {
            Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(metalakeName);
            PolicyPO.Builder builder = PolicyPO.builder().withMetalakeId(metalakeId);
            PolicyPO policyPO = POConverters.initializePolicyPOWithVersion(policyEntity, builder);
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(PolicyMetaMapper.class, mapper -> {
                if (overwritten) {
                    mapper.insertPolicyMetaOnDuplicateKeyUpdate(policyPO);
                } else {
                    mapper.insertPolicyMeta(policyPO);
                }
            }), () -> SessionUtils.doWithoutCommit(PolicyVersionMapper.class, mapper -> {
                if (overwritten) {
                    mapper.insertPolicyVersionOnDuplicateKeyUpdate(policyPO.getPolicyVersionPO());
                } else {
                    mapper.insertPolicyVersion(policyPO.getPolicyVersionPO());
                }
            }));
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.POLICY, policyEntity.toString());
            throw e;
        }
    }

    public <E extends Entity & HasIdentifier> PolicyEntity updatePolicy(NameIdentifier ident, Function<E, E> updater) throws IOException {
        Integer updateResult;
        String metalakeName = ident.namespace().level(0);
        PolicyPO oldPolicyPO = this.getPolicyPOByMetalakeAndName(metalakeName, ident.name());
        PolicyEntity oldPolicyEntity = POConverters.fromPolicyPO(oldPolicyPO, ident.namespace());
        PolicyEntity updatedPolicyEntity = (PolicyEntity)updater.apply(oldPolicyEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldPolicyEntity.id(), updatedPolicyEntity.id()), (String)"The updated policy entity id: %s must have the same id as the old entity id %s", (Object)updatedPolicyEntity.id(), (Object)oldPolicyEntity.id());
        try {
            boolean checkNeedUpdateVersion = POConverters.checkPolicyVersionNeedUpdate(oldPolicyPO.getPolicyVersionPO(), updatedPolicyEntity);
            PolicyPO newPolicyPO = POConverters.updatePolicyPOWithVersion(oldPolicyPO, updatedPolicyEntity, checkNeedUpdateVersion);
            if (checkNeedUpdateVersion) {
                SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(PolicyVersionMapper.class, mapper -> mapper.insertPolicyVersion(newPolicyPO.getPolicyVersionPO())), () -> SessionUtils.doWithoutCommit(PolicyMetaMapper.class, mapper -> mapper.updatePolicyMeta(newPolicyPO, oldPolicyPO)));
                updateResult = 1;
            } else {
                updateResult = SessionUtils.doWithCommitAndFetchResult(PolicyMetaMapper.class, mapper -> mapper.updatePolicyMeta(newPolicyPO, oldPolicyPO));
            }
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.POLICY, updatedPolicyEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult > 0) {
            return updatedPolicyEntity;
        }
        throw new IOException("Failed to update the entity: " + String.valueOf(updatedPolicyEntity));
    }

    public boolean deletePolicy(NameIdentifier ident) {
        String metalakeName = ident.namespace().level(0);
        int[] policyMetaDeletedCount = new int[]{0};
        int[] policyVersionDeletedCount = new int[]{0};
        SessionUtils.doMultipleWithCommit(() -> {
            policyMetaDeletedCount[0] = SessionUtils.getWithoutCommit(PolicyMetaMapper.class, mapper -> mapper.softDeletePolicyByMetalakeAndPolicyName(metalakeName, ident.name()));
        }, () -> {
            policyVersionDeletedCount[0] = SessionUtils.getWithoutCommit(PolicyVersionMapper.class, mapper -> mapper.softDeletePolicyVersionByMetalakeAndPolicyName(metalakeName, ident.name()));
        });
        return policyMetaDeletedCount[0] + policyVersionDeletedCount[0] > 0;
    }

    public List<PolicyEntity> listPoliciesForMetadataObject(NameIdentifier objectIdent, Entity.EntityType objectType) throws NoSuchEntityException, IOException {
        List PolicyPOs;
        MetadataObject metadataObject = NameIdentifierUtil.toMetadataObject(objectIdent, objectType);
        String metalake = objectIdent.namespace().level(0);
        try {
            Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(metalake);
            Long metadataObjectId = MetadataObjectService.getMetadataObjectId(metalakeId, metadataObject.fullName(), metadataObject.type());
            PolicyPOs = SessionUtils.getWithoutCommit(PolicyMetadataObjectRelMapper.class, mapper -> mapper.listPolicyPOsByMetadataObjectIdAndType(metadataObjectId, metadataObject.type().toString()));
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.POLICY, objectIdent.toString());
            throw e;
        }
        return PolicyPOs.stream().map(PolicyPO2 -> POConverters.fromPolicyPO(PolicyPO2, NamespaceUtil.ofPolicy(metalake))).collect(Collectors.toList());
    }

    public PolicyEntity getPolicyForMetadataObject(NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier policyIdent) throws NoSuchEntityException, IOException {
        PolicyPO policyPO;
        MetadataObject metadataObject = NameIdentifierUtil.toMetadataObject(objectIdent, objectType);
        String metalake = objectIdent.namespace().level(0);
        try {
            Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(metalake);
            Long metadataObjectId = MetadataObjectService.getMetadataObjectId(metalakeId, metadataObject.fullName(), metadataObject.type());
            policyPO = SessionUtils.getWithoutCommit(PolicyMetadataObjectRelMapper.class, mapper -> mapper.getPolicyPOsByMetadataObjectAndPolicyName(metadataObjectId, metadataObject.type().toString(), policyIdent.name()));
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.POLICY, policyIdent.toString());
            throw e;
        }
        if (policyPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.POLICY.name().toLowerCase(), policyIdent.name()});
        }
        return POConverters.fromPolicyPO(policyPO, NamespaceUtil.ofPolicy(metalake));
    }

    public List<GenericEntity> listAssociatedEntitiesForPolicy(NameIdentifier policyIdent) throws IOException {
        String metalakeName = policyIdent.namespace().level(0);
        String policyName = policyIdent.name();
        try {
            List policyMetadataObjectRelPOs = SessionUtils.doWithCommitAndFetchResult(PolicyMetadataObjectRelMapper.class, mapper -> mapper.listPolicyMetadataObjectRelsByMetalakeAndPolicyName(metalakeName, policyName));
            return policyMetadataObjectRelPOs.stream().map(r -> GenericEntity.builder().withId(r.getMetadataObjectId()).withEntityType(MetadataObjectUtil.toEntityType(MetadataObject.Type.valueOf((String)r.getMetadataObjectType()))).build()).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.POLICY, policyIdent.toString());
            throw e;
        }
    }

    public List<PolicyEntity> associatePoliciesWithMetadataObject(NameIdentifier objectIdent, Entity.EntityType objectType, NameIdentifier[] policiesToAdd, NameIdentifier[] policiesToRemove) throws NoSuchEntityException, EntityAlreadyExistsException, IOException {
        MetadataObject metadataObject = NameIdentifierUtil.toMetadataObject(objectIdent, objectType);
        String metalake = objectIdent.namespace().level(0);
        try {
            Long metalakeId = MetalakeMetaService.getInstance().getMetalakeIdByName(metalake);
            Long metadataObjectId = MetadataObjectService.getMetadataObjectId(metalakeId, metadataObject.fullName(), metadataObject.type());
            List<String> policyNamesToAdd = Arrays.stream(policiesToAdd).map(NameIdentifier::name).collect(Collectors.toList());
            List policyPOsToAdd = policyNamesToAdd.isEmpty() ? Collections.emptyList() : this.getPolicyPOsByMetalakeAndNames(metalake, policyNamesToAdd);
            List<String> policyNamesToRemove = Arrays.stream(policiesToRemove).map(NameIdentifier::name).collect(Collectors.toList());
            List policyPOsToRemove = policyNamesToRemove.isEmpty() ? Collections.emptyList() : this.getPolicyPOsByMetalakeAndNames(metalake, policyNamesToRemove);
            SessionUtils.doMultipleWithCommit(() -> {
                if (policyPOsToAdd.isEmpty()) {
                    return;
                }
                List policyRelsToAdd = policyPOsToAdd.stream().map(policyPO -> POConverters.initializePolicyMetadataObjectRelPOWithVersion(policyPO.getPolicyId(), metadataObjectId, metadataObject.type().toString())).collect(Collectors.toList());
                SessionUtils.doWithoutCommit(PolicyMetadataObjectRelMapper.class, mapper -> mapper.batchInsertPolicyMetadataObjectRels(policyRelsToAdd));
            }, () -> {
                if (policyPOsToRemove.isEmpty()) {
                    return;
                }
                List policyIdsToRemove = policyPOsToRemove.stream().map(PolicyPO::getPolicyId).collect(Collectors.toList());
                SessionUtils.doWithoutCommit(PolicyMetadataObjectRelMapper.class, mapper -> mapper.batchDeletePolicyMetadataObjectRelsByPolicyIdsAndMetadataObject(metadataObjectId, metadataObject.type().toString(), policyIdsToRemove));
            });
            List policyPOs = SessionUtils.getWithoutCommit(PolicyMetadataObjectRelMapper.class, mapper -> mapper.listPolicyPOsByMetadataObjectIdAndType(metadataObjectId, metadataObject.type().toString()));
            return policyPOs.stream().map(policyPO -> POConverters.fromPolicyPO(policyPO, NamespaceUtil.ofPolicy(metalake))).collect(Collectors.toList());
        }
        catch (RuntimeException e) {
            ExceptionUtils.checkSQLException(e, Entity.EntityType.POLICY, objectIdent.toString());
            throw e;
        }
    }

    public int deletePolicyAndVersionMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        int policyDeletedCount = SessionUtils.doWithCommitAndFetchResult(PolicyMetaMapper.class, mapper -> mapper.deletePolicyMetasByLegacyTimeline(legacyTimeline, limit));
        int policyVersionDeletedCount = SessionUtils.doWithCommitAndFetchResult(PolicyVersionMapper.class, mapper -> mapper.deletePolicyVersionsByLegacyTimeline(legacyTimeline, limit));
        return policyDeletedCount + policyVersionDeletedCount;
    }

    public int deletePolicyVersionsByRetentionCount(Long versionRetentionCount, int limit) {
        List policyMaxVersions = SessionUtils.getWithoutCommit(PolicyVersionMapper.class, mapper -> mapper.selectPolicyVersionsByRetentionCount(versionRetentionCount));
        int totalDeletedCount = 0;
        for (PolicyMaxVersionPO policyMaxVersion : policyMaxVersions) {
            long versionRetentionLine = policyMaxVersion.getVersion() - versionRetentionCount;
            int deletedCount = SessionUtils.doWithCommitAndFetchResult(PolicyVersionMapper.class, mapper -> mapper.softDeletePolicyVersionsByRetentionLine(policyMaxVersion.getPolicyId(), versionRetentionLine, limit));
            totalDeletedCount += deletedCount;
            LOG.info("Soft delete policyVersions count: {} which versions are smaller than or equal to versionRetentionLine: {}, the current policyId and maxVersion is: <{}, {}>.", new Object[]{deletedCount, versionRetentionLine, policyMaxVersion.getPolicyId(), policyMaxVersion.getVersion()});
        }
        return totalDeletedCount;
    }

    private PolicyPO getPolicyPOByMetalakeAndName(String metalakeName, String policyName) {
        PolicyPO policyPO = SessionUtils.getWithoutCommit(PolicyMetaMapper.class, mapper -> mapper.selectPolicyMetaByMetalakeAndName(metalakeName, policyName));
        if (policyPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.POLICY.name().toLowerCase(), policyName});
        }
        return policyPO;
    }

    private List<PolicyPO> getPolicyPOsByMetalakeAndNames(String metalakeName, List<String> policyNames) {
        return SessionUtils.getWithoutCommit(PolicyMetaMapper.class, mapper -> mapper.listPolicyPOsByMetalakeAndPolicyNames(metalakeName, policyNames));
    }
}

