/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.ColumnEntity;
import org.apache.gravitino.meta.TableEntity;
import org.apache.gravitino.storage.relational.mapper.TableColumnMapper;
import org.apache.gravitino.storage.relational.po.ColumnPO;
import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;

public class TableColumnMetaService {
    private static final TableColumnMetaService INSTANCE = new TableColumnMetaService();

    private TableColumnMetaService() {
    }

    public static TableColumnMetaService getInstance() {
        return INSTANCE;
    }

    List<ColumnPO> getColumnsByTableIdAndVersion(Long tableId, Long version) {
        List columnPOs = SessionUtils.getWithoutCommit(TableColumnMapper.class, mapper -> mapper.listColumnPOsByTableIdAndVersion(tableId, version));
        return columnPOs.stream().filter(c -> c.getColumnOpType().byteValue() != ColumnPO.ColumnOpType.DELETE.value()).collect(Collectors.toList());
    }

    Long getColumnIdByTableIdAndName(Long tableId, String columnName) {
        Long columnId = SessionUtils.getWithoutCommit(TableColumnMapper.class, mapper -> mapper.selectColumnIdByTableIdAndName(tableId, columnName));
        if (columnId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.COLUMN.name().toLowerCase(Locale.ROOT), columnName});
        }
        return columnId;
    }

    ColumnPO getColumnPOById(Long columnId) {
        ColumnPO columnPO = SessionUtils.getWithoutCommit(TableColumnMapper.class, mapper -> mapper.selectColumnPOById(columnId));
        if (columnPO == null || columnPO.getColumnOpType().byteValue() == ColumnPO.ColumnOpType.DELETE.value()) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.COLUMN.name().toLowerCase(Locale.ROOT), columnId.toString()});
        }
        return columnPO;
    }

    void insertColumnPOs(TablePO tablePO, List<ColumnEntity> columnEntities) {
        List<ColumnPO> columnPOs = POConverters.initializeColumnPOs(tablePO, columnEntities, ColumnPO.ColumnOpType.CREATE);
        SessionUtils.doWithoutCommit(TableColumnMapper.class, mapper -> mapper.insertColumnPOs(columnPOs));
    }

    boolean deleteColumnsByTableId(Long tableId) {
        Integer result = SessionUtils.getWithoutCommit(TableColumnMapper.class, mapper -> mapper.softDeleteColumnsByTableId(tableId));
        return result > 0;
    }

    public int deleteColumnsByLegacyTimeline(Long legacyTimeline, int limit) {
        return SessionUtils.doWithCommitAndFetchResult(TableColumnMapper.class, mapper -> mapper.deleteColumnPOsByLegacyTimeline(legacyTimeline, limit));
    }

    boolean isColumnUpdated(TableEntity oldTable, TableEntity newTable) {
        Map oldColumns = oldTable.columns() == null ? Collections.emptyMap() : oldTable.columns().stream().collect(Collectors.toMap(ColumnEntity::id, Function.identity()));
        Map newColumns = newTable.columns() == null ? Collections.emptyMap() : newTable.columns().stream().collect(Collectors.toMap(ColumnEntity::id, Function.identity()));
        return oldColumns.size() != newColumns.size() || !oldColumns.equals(newColumns);
    }

    void updateColumnPOsFromTableDiff(TableEntity oldTable, TableEntity newTable, TablePO newTablePO) {
        Map oldColumns = oldTable.columns() == null ? Collections.emptyMap() : oldTable.columns().stream().collect(Collectors.toMap(ColumnEntity::id, Function.identity()));
        Map newColumns = newTable.columns() == null ? Collections.emptyMap() : newTable.columns().stream().collect(Collectors.toMap(ColumnEntity::id, Function.identity()));
        ArrayList columnPOsToInsert = Lists.newArrayList();
        for (ColumnEntity newColumn : newColumns.values()) {
            ColumnEntity oldColumn = (ColumnEntity)oldColumns.get(newColumn.id());
            if (oldColumn != null && oldColumn.equals(newColumn)) continue;
            columnPOsToInsert.add(POConverters.initializeColumnPO(newTablePO, newColumn, ColumnPO.ColumnOpType.UPDATE));
        }
        for (ColumnEntity oldColumn : oldColumns.values()) {
            if (newColumns.containsKey(oldColumn.id())) continue;
            columnPOsToInsert.add(POConverters.initializeColumnPO(newTablePO, oldColumn, ColumnPO.ColumnOpType.DELETE));
        }
        if (columnPOsToInsert.isEmpty()) {
            return;
        }
        SessionUtils.doWithoutCommit(TableColumnMapper.class, mapper -> mapper.insertColumnPOs(columnPOsToInsert));
    }
}

