/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.serialize;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.BaseExpression;
import com.googlecode.aviator.ClassExpression;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.ExpressionAccessor;
import com.googlecode.aviator.code.asm.ClassDefiner;
import com.googlecode.aviator.lexer.SymbolTable;
import com.googlecode.aviator.lexer.token.Variable;
import com.googlecode.aviator.parser.AviatorClassLoader;
import com.googlecode.aviator.runtime.type.AviatorBoolean;
import com.googlecode.aviator.runtime.type.AviatorNil;
import com.googlecode.aviator.runtime.type.Range;
import com.googlecode.aviator.utils.Env;
import com.googlecode.aviator.utils.Reflector;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.HashMap;
import java.util.Map;

public class AviatorObjectInputStream
extends ObjectInputStream {
    private AviatorClassLoader classLoader;
    private AviatorEvaluatorInstance instance;
    private Map<String, byte[]> classBytesCache = new HashMap<String, byte[]>();

    public AviatorObjectInputStream(InputStream in, AviatorEvaluatorInstance instance) throws IOException {
        super(in);
        this.classLoader = instance.getAviatorClassLoader(true);
        this.instance = instance;
        this.enableResolveObject(true);
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        Object object = super.resolveObject(obj);
        if (object instanceof BaseExpression) {
            BaseExpression exp = (BaseExpression)object;
            this.configureExpression(exp);
        }
        if (object instanceof Env) {
            ((Env)object).setInstance(this.instance);
        }
        if (object instanceof AviatorBoolean) {
            AviatorBoolean bool = (AviatorBoolean)object;
            object = bool.getBooleanValue() ? AviatorBoolean.TRUE : AviatorBoolean.FALSE;
        }
        if (object instanceof AviatorNil) {
            object = AviatorNil.NIL;
        }
        if (object instanceof Range && ((Range)object).isLoop()) {
            object = Range.LOOP;
        }
        if (object instanceof Variable) {
            object = SymbolTable.tryReserveKeyword((Variable)object);
        }
        return object;
    }

    private void configureExpression(BaseExpression exp) {
        ExpressionAccessor.setInstance(exp, this.instance);
        if (exp instanceof ClassExpression) {
            ((ClassExpression)exp).setClassBytes(this.classBytesCache.get(exp.getClass().getName()));
        }
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = super.resolveClass(desc);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null && desc.getName().startsWith("AviatorScript_")) {
            int n;
            int len = this.readInt();
            byte[] classBytes = new byte[len];
            for (int readed = 0; readed < classBytes.length && (n = this.read(classBytes, readed, classBytes.length - readed)) >= 0; readed += n) {
            }
            String name = desc.getName();
            this.classBytesCache.put(name, classBytes);
            try {
                clazz = Class.forName(name, false, this.classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (clazz == null) {
                try {
                    clazz = ClassDefiner.defineClass(desc.getName(), Expression.class, classBytes, this.classLoader, true);
                }
                catch (Throwable t) {
                    throw Reflector.sneakyThrow(t);
                }
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Class not found:" + desc.getName());
        }
        return clazz;
    }
}

