/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.lance.common.ops.gravitino;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.lancedb.lance.namespace.LanceNamespaceException;
import com.lancedb.lance.namespace.util.CommonUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.Catalog;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.lance.common.config.LanceConfig;
import org.apache.gravitino.lance.common.ops.LanceNamespaceOperations;
import org.apache.gravitino.lance.common.ops.LanceTableOperations;
import org.apache.gravitino.lance.common.ops.NamespaceWrapper;
import org.apache.gravitino.lance.common.ops.gravitino.GravitinoLanceNameSpaceOperations;
import org.apache.gravitino.lance.common.ops.gravitino.GravitinoLanceTableOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GravitinoLanceNamespaceWrapper
extends NamespaceWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(GravitinoLanceNamespaceWrapper.class);
    private GravitinoClient client;
    private LanceNamespaceOperations namespaceOperations;
    private LanceTableOperations tableOperations;

    @VisibleForTesting
    GravitinoLanceNamespaceWrapper() {
        super(null);
    }

    public GravitinoLanceNamespaceWrapper(LanceConfig config) {
        super(config);
    }

    public GravitinoClient getClient() {
        return this.client;
    }

    @Override
    protected void initialize() {
        String uri = (String)this.config().get(LanceConfig.NAMESPACE_BACKEND_URI);
        String metalakeName = (String)this.config().get(LanceConfig.METALAKE_NAME);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)metalakeName), (Object)"Metalake name must be provided for Lance Gravitino namespace backend");
        this.client = GravitinoClient.builder((String)uri).withMetalake(metalakeName).build();
        this.namespaceOperations = new GravitinoLanceNameSpaceOperations(this);
        this.tableOperations = new GravitinoLanceTableOperations(this);
    }

    @Override
    public LanceNamespaceOperations newNamespaceOps() {
        return this.namespaceOperations;
    }

    @Override
    protected LanceTableOperations newTableOps() {
        return this.tableOperations;
    }

    @Override
    public void close() {
        if (this.client != null) {
            try {
                this.client.close();
            }
            catch (Exception e) {
                LOG.warn("Error closing Gravitino client", (Throwable)e);
            }
        }
    }

    public boolean isLakehouseCatalog(Catalog catalog) {
        return catalog.type().equals((Object)Catalog.Type.RELATIONAL) && "lakehouse-generic".equals(catalog.provider());
    }

    public Catalog loadAndValidateLakehouseCatalog(String catalogName) {
        Catalog catalog;
        try {
            catalog = this.client.loadCatalog(catalogName);
        }
        catch (NoSuchCatalogException e) {
            throw LanceNamespaceException.notFound((String)("Catalog not found: " + catalogName), (String)NoSuchCatalogException.class.getSimpleName(), (String)catalogName, (String)CommonUtil.formatCurrentStackTrace());
        }
        if (!this.isLakehouseCatalog(catalog)) {
            throw LanceNamespaceException.notFound((String)("Catalog is not a lakehouse catalog: " + catalogName), (String)NoSuchCatalogException.class.getSimpleName(), (String)catalogName, (String)CommonUtil.formatCurrentStackTrace());
        }
        return catalog;
    }
}

