/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.config.plugins.util.PluginUtil;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverContext;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverInterceptor;
import org.apache.logging.log4j.status.StatusLogger;

public class TemplateResolverInterceptors {
    private static final Logger LOGGER = StatusLogger.getLogger();

    private TemplateResolverInterceptors() {
    }

    public static <V, C extends TemplateResolverContext<V, C>, I extends TemplateResolverInterceptor<V, C>> List<I> populateInterceptors(List<String> pluginPackages, Class<V> valueClass, Class<C> contextClass) {
        Map pluginTypeByName = PluginUtil.collectPluginsByCategoryAndPackage((String)"JsonTemplateResolverInterceptor", pluginPackages);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("found {} plugins of category \"{}\": {}", (Object)pluginTypeByName.size(), (Object)"JsonTemplateResolverFactory", pluginTypeByName.keySet());
        }
        List<I> interceptors = TemplateResolverInterceptors.populateInterceptors(pluginTypeByName, valueClass, contextClass);
        LOGGER.debug("{} interceptors matched out of {} for value class {} and context class {}", (Object)interceptors.size(), (Object)pluginTypeByName.size(), valueClass, contextClass);
        return interceptors;
    }

    private static <V, C extends TemplateResolverContext<V, C>, I extends TemplateResolverInterceptor<V, C>> List<I> populateInterceptors(Map<String, PluginType<?>> pluginTypeByName, Class<V> valueClass, Class<C> contextClass) {
        ArrayList<I> interceptors = new ArrayList<I>();
        Set<String> pluginNames = pluginTypeByName.keySet();
        for (String pluginName : pluginNames) {
            TemplateResolverInterceptor<?, ?> rawInterceptor;
            I interceptor;
            PluginType<?> pluginType = pluginTypeByName.get(pluginName);
            Class pluginClass = pluginType.getPluginClass();
            boolean pluginClassMatched = TemplateResolverInterceptor.class.isAssignableFrom(pluginClass);
            if (!pluginClassMatched || (interceptor = TemplateResolverInterceptors.castInterceptor(valueClass, contextClass, rawInterceptor = TemplateResolverInterceptors.instantiateInterceptor(pluginName, pluginClass))) == null) continue;
            interceptors.add(interceptor);
        }
        return interceptors;
    }

    private static TemplateResolverInterceptor<?, ?> instantiateInterceptor(String pluginName, Class<?> pluginClass) {
        try {
            return (TemplateResolverInterceptor)PluginUtil.instantiatePlugin(pluginClass);
        }
        catch (Exception error) {
            String message = String.format("failed instantiating resolver interceptor plugin %s of name %s", pluginClass, pluginName);
            throw new RuntimeException(message, error);
        }
    }

    private static <V, C extends TemplateResolverContext<V, C>, I extends TemplateResolverInterceptor<V, C>> I castInterceptor(Class<V> valueClass, Class<C> contextClass, TemplateResolverInterceptor<?, ?> interceptor) {
        Class<?> interceptorValueClass = interceptor.getValueClass();
        Class<?> interceptorContextClass = interceptor.getContextClass();
        boolean interceptorValueClassMatched = valueClass.isAssignableFrom(interceptorValueClass);
        boolean interceptorContextClassMatched = contextClass.isAssignableFrom(interceptorContextClass);
        if (interceptorValueClassMatched && interceptorContextClassMatched) {
            TemplateResolverInterceptor<?, ?> typedInterceptor = interceptor;
            return (I)typedInterceptor;
        }
        return null;
    }
}

