/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.Map;
import org.apache.gravitino.Audit;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.MetadataObjects;
import org.apache.gravitino.Schema;
import org.apache.gravitino.authorization.SupportsRoles;
import org.apache.gravitino.client.MetadataObjectPolicyOperations;
import org.apache.gravitino.client.MetadataObjectRoleOperations;
import org.apache.gravitino.client.MetadataObjectTagOperations;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.SchemaDTO;
import org.apache.gravitino.exceptions.NoSuchPolicyException;
import org.apache.gravitino.exceptions.NoSuchTagException;
import org.apache.gravitino.exceptions.PolicyAlreadyAssociatedException;
import org.apache.gravitino.policy.Policy;
import org.apache.gravitino.policy.SupportsPolicies;
import org.apache.gravitino.tag.SupportsTags;
import org.apache.gravitino.tag.Tag;

class GenericSchema
implements Schema,
SupportsTags,
SupportsRoles,
SupportsPolicies {
    private final SchemaDTO schemaDTO;
    private final MetadataObjectTagOperations objectTagOperations;
    private final MetadataObjectRoleOperations objectRoleOperations;
    private final MetadataObjectPolicyOperations objectPolicyOperations;

    GenericSchema(SchemaDTO schemaDTO, RESTClient restClient, String metalake, String catalog) {
        this.schemaDTO = schemaDTO;
        MetadataObject schemaObject = MetadataObjects.of((String)catalog, (String)schemaDTO.name(), (MetadataObject.Type)MetadataObject.Type.SCHEMA);
        this.objectTagOperations = new MetadataObjectTagOperations(metalake, schemaObject, restClient);
        this.objectRoleOperations = new MetadataObjectRoleOperations(metalake, schemaObject, restClient);
        this.objectPolicyOperations = new MetadataObjectPolicyOperations(metalake, schemaObject, restClient);
    }

    public SupportsTags supportsTags() {
        return this;
    }

    public SupportsPolicies supportsPolicies() {
        return this;
    }

    public SupportsRoles supportsRoles() {
        return this;
    }

    public String name() {
        return this.schemaDTO.name();
    }

    public String comment() {
        return this.schemaDTO.comment();
    }

    public Map<String, String> properties() {
        return this.schemaDTO.properties();
    }

    public Audit auditInfo() {
        return this.schemaDTO.auditInfo();
    }

    public String[] listTags() {
        return this.objectTagOperations.listTags();
    }

    public Tag[] listTagsInfo() {
        return this.objectTagOperations.listTagsInfo();
    }

    public Tag getTag(String name) throws NoSuchTagException {
        return this.objectTagOperations.getTag(name);
    }

    public String[] associateTags(String[] tagsToAdd, String[] tagsToRemove) {
        return this.objectTagOperations.associateTags(tagsToAdd, tagsToRemove);
    }

    public String[] listPolicies() {
        return this.objectPolicyOperations.listPolicies();
    }

    public Policy[] listPolicyInfos() {
        return this.objectPolicyOperations.listPolicyInfos();
    }

    public Policy getPolicy(String name) throws NoSuchPolicyException {
        return this.objectPolicyOperations.getPolicy(name);
    }

    public String[] associatePolicies(String[] policiesToAdd, String[] policiesToRemove) throws PolicyAlreadyAssociatedException {
        return this.objectPolicyOperations.associatePolicies(policiesToAdd, policiesToRemove);
    }

    public String[] listBindingRoleNames() {
        return this.objectRoleOperations.listBindingRoleNames();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericSchema)) {
            return false;
        }
        GenericSchema that = (GenericSchema)obj;
        return this.schemaDTO.equals((Object)that.schemaDTO);
    }

    public int hashCode() {
        return this.schemaDTO.hashCode();
    }
}

