/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver.order;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.resolver.PathLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.RouterResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.store.MembershipStore;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsRequest;
import org.apache.hadoop.hdfs.server.federation.store.protocol.GetNamenodeRegistrationsResponse;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailableSpaceResolver
extends RouterResolver<String, SubclusterAvailableSpace> {
    private static final Logger LOG = LoggerFactory.getLogger(AvailableSpaceResolver.class);
    public static final String BALANCER_PREFERENCE_KEY = "dfs.federation.router.available-space-resolver.balanced-space-preference-fraction";
    public static final float BALANCER_PREFERENCE_DEFAULT = 0.6f;
    private static final Random RAND = new Random();
    private SubclusterSpaceComparator comparator;

    public AvailableSpaceResolver(Configuration conf, Router routerService) {
        super(conf, routerService);
        float balancedPreference = conf.getFloat(BALANCER_PREFERENCE_KEY, 0.6f);
        if ((double)balancedPreference < 0.5) {
            LOG.warn("The balancer preference value is less than 0.5. That means more files will be allocated in cluster with lower available space.");
        }
        this.comparator = new SubclusterSpaceComparator(balancedPreference);
    }

    @Override
    protected Map<String, SubclusterAvailableSpace> getSubclusterInfo(MembershipStore membershipStore) {
        HashMap<String, SubclusterAvailableSpace> mapping = new HashMap<String, SubclusterAvailableSpace>();
        try {
            GetNamenodeRegistrationsRequest request = GetNamenodeRegistrationsRequest.newInstance();
            GetNamenodeRegistrationsResponse response = membershipStore.getNamenodeRegistrations(request);
            List<MembershipState> nns = response.getNamenodeMemberships();
            for (MembershipState nn : nns) {
                try {
                    String nsId = nn.getNameserviceId();
                    long availableSpace = nn.getStats().getAvailableSpace();
                    mapping.put(nsId, new SubclusterAvailableSpace(nsId, availableSpace));
                }
                catch (Exception e) {
                    LOG.error("Cannot get stats info for {}: {}.", (Object)nn, (Object)e.getMessage());
                }
            }
        }
        catch (IOException ioe) {
            LOG.error("Cannot get Namenodes from the State Store.", (Throwable)ioe);
        }
        return mapping;
    }

    @Override
    protected String chooseFirstNamespace(String path, PathLocation loc) {
        Map subclusterInfo = this.getSubclusterMapping();
        LinkedList subclusterList = new LinkedList(subclusterInfo.values());
        Collections.sort(subclusterList, this.comparator);
        return subclusterList.size() > 0 ? ((SubclusterAvailableSpace)subclusterList.get(0)).getNameserviceId() : null;
    }

    static final class SubclusterSpaceComparator
    implements Comparator<SubclusterAvailableSpace>,
    Serializable {
        private int balancedPreference;

        SubclusterSpaceComparator(float balancedPreference) {
            Preconditions.checkArgument((balancedPreference <= 1.0f && balancedPreference >= 0.0f ? 1 : 0) != 0, (Object)"The balancer preference value should be in the range 0.0 - 1.0");
            this.balancedPreference = (int)(100.0f * balancedPreference);
        }

        @Override
        public int compare(SubclusterAvailableSpace cluster1, SubclusterAvailableSpace cluster2) {
            int ret;
            int n = ret = cluster1.getAvailableSpace() > cluster2.getAvailableSpace() ? -1 : 1;
            if (ret < 0) {
                return RAND.nextInt(100) < this.balancedPreference ? -1 : 1;
            }
            return RAND.nextInt(100) < this.balancedPreference ? 1 : -1;
        }
    }

    static class SubclusterAvailableSpace {
        private final String nsId;
        private final long availableSpace;

        SubclusterAvailableSpace(String nsId, long availableSpace) {
            this.nsId = nsId;
            this.availableSpace = availableSpace;
        }

        public String getNameserviceId() {
            return this.nsId;
        }

        public long getAvailableSpace() {
            return this.availableSpace;
        }
    }
}

