/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.StateStoreDFSCluster;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeContext;
import org.apache.hadoop.hdfs.server.federation.resolver.MembershipNamenodeResolver;
import org.apache.hadoop.hdfs.server.federation.router.NamenodeHeartbeatService;
import org.apache.hadoop.util.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRouterNamenodeMonitoring {
    private static StateStoreDFSCluster cluster;
    private static MiniRouterDFSCluster.RouterContext routerContext;
    private static MembershipNamenodeResolver resolver;
    private String ns0;
    private String ns1;
    private long initializedTime;

    @Before
    public void setUp() throws Exception {
        cluster = new StateStoreDFSCluster(true, 2);
        Configuration routerConf = new RouterConfigBuilder().stateStore().admin().rpc().enableLocalHeartbeat(true).heartbeat().build();
        StringBuilder sb = new StringBuilder();
        this.ns0 = cluster.getNameservices().get(0);
        MiniRouterDFSCluster.NamenodeContext context = cluster.getNamenodes(this.ns0).get(1);
        routerConf.set("dfs.nameservice.id", this.ns0);
        routerConf.set("dfs.ha.namenode.id", context.getNamenodeId());
        sb = new StringBuilder();
        this.ns1 = cluster.getNameservices().get(1);
        for (MiniRouterDFSCluster.NamenodeContext ctx : cluster.getNamenodes(this.ns1)) {
            String suffix = ctx.getConfSuffix();
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(suffix);
        }
        routerConf.set("dfs.federation.router.monitor.namenode", sb.toString());
        cluster.addRouterOverrides(routerConf);
        cluster.startCluster();
        cluster.startRouters();
        cluster.waitClusterUp();
        routerContext = cluster.getRandomRouter();
        resolver = (MembershipNamenodeResolver)routerContext.getRouter().getNamenodeResolver();
        this.initializedTime = Time.now();
    }

    @After
    public void tearDown() {
        if (cluster != null) {
            cluster.stopRouter(routerContext);
            cluster.shutdown();
            cluster = null;
        }
    }

    @Test
    public void testNamenodeMonitoring() throws Exception {
        for (String ns : cluster.getNameservices()) {
            cluster.switchToActive(ns, "nn0");
            cluster.switchToStandby(ns, "nn1");
        }
        Collection heartbeatServices = routerContext.getRouter().getNamenodeHearbeatServices();
        for (NamenodeHeartbeatService service : heartbeatServices) {
            service.periodicInvoke();
        }
        resolver.loadCache(true);
        List namespaceInfo0 = resolver.getNamenodesForNameserviceId(this.ns0);
        List namespaceInfo1 = resolver.getNamenodesForNameserviceId(this.ns1);
        Assert.assertEquals((Object)"nn0", (Object)((FederationNamenodeContext)namespaceInfo0.get(1)).getNamenodeId());
        Assert.assertTrue((((FederationNamenodeContext)namespaceInfo0.get(1)).getDateModified() < this.initializedTime ? 1 : 0) != 0);
        Assert.assertEquals((Object)"nn1", (Object)((FederationNamenodeContext)namespaceInfo0.get(0)).getNamenodeId());
        Assert.assertTrue((((FederationNamenodeContext)namespaceInfo0.get(0)).getDateModified() > this.initializedTime ? 1 : 0) != 0);
        Assert.assertEquals((Object)"nn0", (Object)((FederationNamenodeContext)namespaceInfo1.get(0)).getNamenodeId());
        Assert.assertTrue((((FederationNamenodeContext)namespaceInfo1.get(0)).getDateModified() > this.initializedTime ? 1 : 0) != 0);
        Assert.assertEquals((Object)"nn1", (Object)((FederationNamenodeContext)namespaceInfo1.get(1)).getNamenodeId());
        Assert.assertTrue((((FederationNamenodeContext)namespaceInfo1.get(1)).getDateModified() > this.initializedTime ? 1 : 0) != 0);
    }
}

