/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.resourceestimator.skylinestore.validator;

import java.util.List;
import org.apache.hadoop.resourceestimator.common.api.RecurrenceId;
import org.apache.hadoop.resourceestimator.common.api.ResourceSkyline;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.NullPipelineIdException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.NullRLESparseResourceAllocationException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.NullRecurrenceIdException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.NullResourceSkylineException;
import org.apache.hadoop.resourceestimator.skylinestore.exceptions.SkylineStoreException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkylineStoreValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(SkylineStoreValidator.class);

    public final void validate(RecurrenceId recurrenceId) throws SkylineStoreException {
        if (recurrenceId == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Recurrence id is null, please try again by specifying a valid Recurrence id.");
            LOGGER.error(sb.toString());
            throw new NullRecurrenceIdException(sb.toString());
        }
    }

    public final void validate(String pipelineId) throws SkylineStoreException {
        if (pipelineId == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("pipelineId is null, please try again by specifying a valid pipelineId.");
            LOGGER.error(sb.toString());
            throw new NullPipelineIdException(sb.toString());
        }
    }

    public final void validate(RecurrenceId recurrenceId, List<ResourceSkyline> resourceSkylines) throws SkylineStoreException {
        this.validate(recurrenceId);
        if (resourceSkylines == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("ResourceSkylines for " + recurrenceId + " is null, please try again by " + "specifying valid ResourceSkylines.");
            LOGGER.error(sb.toString());
            throw new NullResourceSkylineException(sb.toString());
        }
    }

    public final void validate(String pipelineId, RLESparseResourceAllocation resourceOverTime) throws SkylineStoreException {
        this.validate(pipelineId);
        if (resourceOverTime == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Resource allocation for " + pipelineId + " is null.");
            LOGGER.error(sb.toString());
            throw new NullRLESparseResourceAllocationException(sb.toString());
        }
    }
}

