/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.commons.cli;

final class OptionValidator {
    static final char[] ADDITIONAL_OPTION_CHARS = new char[]{'?', '@'};
    static final char[] ADDITIONAL_LONG_CHARS = new char[]{'-'};

    OptionValidator() {
    }

    private static boolean isValidChar(char c) {
        return Character.isJavaIdentifierPart(c) || OptionValidator.search(ADDITIONAL_LONG_CHARS, c);
    }

    private static boolean isValidOpt(char c) {
        return Character.isJavaIdentifierPart(c) || OptionValidator.search(ADDITIONAL_OPTION_CHARS, c);
    }

    private static boolean search(char[] chars, char c) {
        for (char a : chars) {
            if (a != c) continue;
            return true;
        }
        return false;
    }

    static String validate(String option) throws IllegalArgumentException {
        if (option == null) {
            return null;
        }
        if (option.isEmpty()) {
            throw new IllegalArgumentException("Empty option name.");
        }
        char[] chars = option.toCharArray();
        char ch0 = chars[0];
        if (!OptionValidator.isValidOpt(ch0)) {
            throw new IllegalArgumentException(String.format("Illegal option name '%s'.", Character.valueOf(ch0)));
        }
        if (option.length() > 1) {
            for (int i = 1; i < chars.length; ++i) {
                char ch = chars[i];
                if (OptionValidator.isValidChar(ch)) continue;
                throw new IllegalArgumentException(String.format("The option '%s' contains an illegal character : '%s'.", option, Character.valueOf(ch)));
            }
        }
        return option;
    }
}

