/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.hadoop.shaded.org.glassfish.grizzly.AbstractTransformer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Buffer;
import org.apache.hadoop.shaded.org.glassfish.grizzly.TransformationException;
import org.apache.hadoop.shaded.org.glassfish.grizzly.TransformationResult;
import org.apache.hadoop.shaded.org.glassfish.grizzly.attributes.AttributeStorage;

public class StringEncoder
extends AbstractTransformer<String, Buffer> {
    protected Charset charset;
    protected String stringTerminator = null;

    public StringEncoder() {
        this((String)null);
    }

    public StringEncoder(String stringTerminator) {
        this(null, null);
    }

    public StringEncoder(Charset charset) {
        this(charset, null);
    }

    public StringEncoder(Charset charset, String stringTerminator) {
        this.charset = charset != null ? charset : Charset.defaultCharset();
        this.stringTerminator = stringTerminator;
    }

    @Override
    public String getName() {
        return "StringEncoder";
    }

    @Override
    protected TransformationResult<String, Buffer> transformImpl(AttributeStorage storage, String input) throws TransformationException {
        byte[] byteRepresentation;
        if (input == null) {
            throw new TransformationException("Input could not be null");
        }
        try {
            if (this.stringTerminator != null) {
                input = input + this.stringTerminator;
            }
            byteRepresentation = input.getBytes(this.charset.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new TransformationException("Charset " + this.charset.name() + " is not supported", e);
        }
        Object output = this.obtainMemoryManager(storage).allocate(byteRepresentation.length + 4);
        if (this.stringTerminator == null) {
            output.putInt(byteRepresentation.length);
        }
        output.put(byteRepresentation);
        output.flip();
        output.allowBufferDispose(true);
        return TransformationResult.createCompletedResult(output, null);
    }

    @Override
    public boolean hasInputRemaining(AttributeStorage storage, String input) {
        return input != null;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

