/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.handler;

import java.util.List;
import org.apache.hadoop.shaded.org.mockito.internal.exceptions.Reporter;
import org.apache.hadoop.shaded.org.mockito.internal.handler.NotifiedMethodInvocationReport;
import org.apache.hadoop.shaded.org.mockito.invocation.Invocation;
import org.apache.hadoop.shaded.org.mockito.invocation.InvocationContainer;
import org.apache.hadoop.shaded.org.mockito.invocation.MockHandler;
import org.apache.hadoop.shaded.org.mockito.listeners.InvocationListener;
import org.apache.hadoop.shaded.org.mockito.mock.MockCreationSettings;

class InvocationNotifierHandler<T>
implements MockHandler<T> {
    private final List<InvocationListener> invocationListeners;
    private final MockHandler<T> mockHandler;

    public InvocationNotifierHandler(MockHandler<T> mockHandler, MockCreationSettings<T> settings) {
        this.mockHandler = mockHandler;
        this.invocationListeners = settings.getInvocationListeners();
    }

    @Override
    public Object handle(Invocation invocation) throws Throwable {
        try {
            Object returnedValue = this.mockHandler.handle(invocation);
            this.notifyMethodCall(invocation, returnedValue);
            return returnedValue;
        }
        catch (Throwable t) {
            this.notifyMethodCallException(invocation, t);
            throw t;
        }
    }

    private void notifyMethodCall(Invocation invocation, Object returnValue) {
        for (InvocationListener listener : this.invocationListeners) {
            try {
                listener.reportInvocation(new NotifiedMethodInvocationReport(invocation, returnValue));
            }
            catch (Throwable listenerThrowable) {
                throw Reporter.invocationListenerThrewException(listener, listenerThrowable);
            }
        }
    }

    private void notifyMethodCallException(Invocation invocation, Throwable exception) {
        for (InvocationListener listener : this.invocationListeners) {
            try {
                listener.reportInvocation(new NotifiedMethodInvocationReport(invocation, exception));
            }
            catch (Throwable listenerThrowable) {
                throw Reporter.invocationListenerThrewException(listener, listenerThrowable);
            }
        }
    }

    @Override
    public MockCreationSettings<T> getMockSettings() {
        return this.mockHandler.getMockSettings();
    }

    @Override
    public InvocationContainer getInvocationContainer() {
        return this.mockHandler.getInvocationContainer();
    }
}

