/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timelineservice.collector;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.yarn.api.records.timeline.TimelineHealth;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetricOperation;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineWriteResponse;
import org.apache.hadoop.yarn.server.timelineservice.collector.TimelineCollectorContext;
import org.apache.hadoop.yarn.server.timelineservice.storage.TimelineWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class TimelineCollector
extends CompositeService {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineCollector.class);
    public static final String SEPARATOR = "_";
    private TimelineWriter writer;
    private ConcurrentMap<String, AggregationStatusTable> aggregationGroups = new ConcurrentHashMap<String, AggregationStatusTable>();
    private static Set<String> entityTypesSkipAggregation = new HashSet<String>();
    private ThreadPoolExecutor pool;
    private volatile boolean readyToAggregate = false;
    private volatile boolean isStopped = false;
    private int maxWriteRetries;
    private long writeRetryInterval;

    public TimelineCollector(String name) {
        super(name);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        int capacity = conf.getInt("yarn.timeline-service.writer.async.queue.capacity", 100);
        this.pool = new ThreadPoolExecutor(1, 1, 3L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(capacity));
        this.pool.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardOldestPolicy());
        this.maxWriteRetries = conf.getInt("yarn.timeline-service.client.max-retries", 30);
        this.writeRetryInterval = conf.getLong("yarn.timeline-service.client.retry-interval-ms", 1000L);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.isStopped = true;
        this.pool.shutdownNow();
        super.serviceStop();
    }

    boolean isStopped() {
        return this.isStopped;
    }

    protected void setWriter(TimelineWriter w) {
        this.writer = w;
    }

    protected Map<String, AggregationStatusTable> getAggregationGroups() {
        return this.aggregationGroups;
    }

    protected void setReadyToAggregate() {
        this.readyToAggregate = true;
    }

    protected boolean isReadyToAggregate() {
        return this.readyToAggregate;
    }

    protected Set<String> getEntityTypesSkipAggregation() {
        return entityTypesSkipAggregation;
    }

    public abstract TimelineCollectorContext getTimelineEntityContext();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineWriteResponse putEntities(TimelineEntities entities, UserGroupInformation callerUgi) throws IOException {
        TimelineWriteResponse response;
        block6: {
            LOG.debug("putEntities(entities={}, callerUgi={})", (Object)entities, (Object)callerUgi);
            response = null;
            try {
                boolean isStorageUp = this.checkRetryWithSleep();
                if (isStorageUp) {
                    TimelineWriter timelineWriter = this.writer;
                    synchronized (timelineWriter) {
                        response = this.writeTimelineEntities(entities, callerUgi);
                        this.flushBufferedTimelineEntities();
                        break block6;
                    }
                }
                String msg = String.format("Failed to putEntities(entities=%s, callerUgi=%s) as Timeline Storage is Down", entities, callerUgi);
                throw new IOException(msg);
            }
            catch (InterruptedException ex) {
                String msg = String.format("Interrupted while retrying to putEntities(entities=%s, callerUgi=%s)", entities, callerUgi);
                throw new IOException(msg);
            }
        }
        return response;
    }

    private boolean checkRetryWithSleep() throws InterruptedException {
        for (int retries = this.maxWriteRetries; retries > 0; --retries) {
            TimelineHealth timelineHealth = this.writer.getHealthStatus();
            if (timelineHealth.getHealthStatus().equals((Object)TimelineHealth.TimelineHealthStatus.RUNNING)) {
                return true;
            }
            try {
                Thread.sleep(this.writeRetryInterval);
                continue;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw ex;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimelineWriteResponse putDomain(TimelineDomain domain, UserGroupInformation callerUgi) throws IOException {
        TimelineWriteResponse response;
        block6: {
            LOG.debug("putDomain(domain={}, callerUgi={})", (Object)domain, (Object)callerUgi);
            response = null;
            try {
                boolean isStorageUp = this.checkRetryWithSleep();
                if (isStorageUp) {
                    TimelineWriter timelineWriter = this.writer;
                    synchronized (timelineWriter) {
                        TimelineCollectorContext context = this.getTimelineEntityContext();
                        response = this.writer.write(context, domain);
                        this.flushBufferedTimelineEntities();
                        break block6;
                    }
                }
                String msg = String.format("Failed to putDomain(domain=%s, callerUgi=%s) as Timeline Storage is Down", domain, callerUgi);
                throw new IOException(msg);
            }
            catch (InterruptedException ex) {
                String msg = String.format("Interrupted while retrying to putDomain(domain=%s, callerUgi=%s)", domain, callerUgi);
                throw new IOException(msg);
            }
        }
        return response;
    }

    private TimelineWriteResponse writeTimelineEntities(TimelineEntities entities, UserGroupInformation callerUgi) throws IOException {
        TimelineCollector.updateAggregateStatus(entities, this.aggregationGroups, this.getEntityTypesSkipAggregation());
        TimelineCollectorContext context = this.getTimelineEntityContext();
        return this.writer.write(context, entities, callerUgi);
    }

    private void flushBufferedTimelineEntities() throws IOException {
        this.writer.flush();
    }

    public void putEntitiesAsync(final TimelineEntities entities, final UserGroupInformation callerUgi) throws IOException {
        LOG.debug("putEntitiesAsync(entities={}, callerUgi={})", (Object)entities, (Object)callerUgi);
        this.pool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    TimelineCollector.this.writeTimelineEntities(entities, callerUgi);
                }
                catch (IOException ie) {
                    LOG.error("Got an exception while writing entity", (Throwable)ie);
                }
            }
        });
    }

    public static TimelineEntity aggregateEntities(TimelineEntities entities, String resultEntityId, String resultEntityType, boolean needsGroupIdInResult) {
        ConcurrentHashMap<String, AggregationStatusTable> aggregationGroups = new ConcurrentHashMap<String, AggregationStatusTable>();
        TimelineCollector.updateAggregateStatus(entities, aggregationGroups, null);
        if (needsGroupIdInResult) {
            return TimelineCollector.aggregate(aggregationGroups, resultEntityId, resultEntityType);
        }
        return TimelineCollector.aggregateWithoutGroupId(aggregationGroups, resultEntityId, resultEntityType);
    }

    static void updateAggregateStatus(TimelineEntities entities, ConcurrentMap<String, AggregationStatusTable> aggregationGroups, Set<String> typesToSkip) {
        for (TimelineEntity e : entities.getEntities()) {
            if (typesToSkip != null && typesToSkip.contains(e.getType()) || e.getMetrics().isEmpty()) continue;
            AggregationStatusTable aggrTable = (AggregationStatusTable)aggregationGroups.get(e.getType());
            if (aggrTable == null) {
                AggregationStatusTable table = new AggregationStatusTable();
                aggrTable = aggregationGroups.putIfAbsent(e.getType(), table);
                if (aggrTable == null) {
                    aggrTable = table;
                }
            }
            aggrTable.update(e);
        }
    }

    static TimelineEntity aggregate(Map<String, AggregationStatusTable> aggregationGroups, String resultEntityId, String resultEntityType) {
        TimelineEntity result = new TimelineEntity();
        result.setId(resultEntityId);
        result.setType(resultEntityType);
        for (Map.Entry<String, AggregationStatusTable> entry : aggregationGroups.entrySet()) {
            entry.getValue().aggregateAllTo(result, entry.getKey());
        }
        return result;
    }

    static TimelineEntity aggregateWithoutGroupId(Map<String, AggregationStatusTable> aggregationGroups, String resultEntityId, String resultEntityType) {
        TimelineEntity result = new TimelineEntity();
        result.setId(resultEntityId);
        result.setType(resultEntityType);
        for (Map.Entry<String, AggregationStatusTable> entry : aggregationGroups.entrySet()) {
            entry.getValue().aggregateAllTo(result, "");
        }
        return result;
    }

    protected static class AggregationStatusTable {
        private ConcurrentMap<TimelineMetric, Map<String, TimelineMetric>> aggregateTable = new ConcurrentHashMap<TimelineMetric, Map<String, TimelineMetric>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(TimelineEntity incoming) {
            String entityId = incoming.getId();
            for (TimelineMetric m : incoming.getMetrics()) {
                HashMap<String, TimelineMetric> tempRow;
                if (m.getRealtimeAggregationOp() == TimelineMetricOperation.NOP) continue;
                HashMap<String, TimelineMetric> aggrRow = (HashMap<String, TimelineMetric>)this.aggregateTable.get(m);
                if (aggrRow == null && (aggrRow = (Map)this.aggregateTable.putIfAbsent(m, tempRow = new HashMap<String, TimelineMetric>())) == null) {
                    aggrRow = tempRow;
                }
                HashMap<String, TimelineMetric> hashMap = aggrRow;
                synchronized (hashMap) {
                    aggrRow.put(entityId, m);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TimelineEntity aggregateTo(TimelineMetric metric, TimelineEntity e, String aggregationGroupId) {
            if (metric.getRealtimeAggregationOp() == TimelineMetricOperation.NOP) {
                return e;
            }
            Map aggrRow = (Map)this.aggregateTable.get(metric);
            if (aggrRow != null) {
                TimelineMetric aggrMetric = new TimelineMetric();
                if (aggregationGroupId.length() > 0) {
                    aggrMetric.setId(metric.getId() + TimelineCollector.SEPARATOR + aggregationGroupId);
                } else {
                    aggrMetric.setId(metric.getId());
                }
                aggrMetric.setRealtimeAggregationOp(TimelineMetricOperation.NOP);
                HashMap status = new HashMap();
                Map map = aggrRow;
                synchronized (map) {
                    for (TimelineMetric m : aggrRow.values()) {
                        TimelineMetric.aggregateTo((TimelineMetric)m, (TimelineMetric)aggrMetric, status);
                        if (m.getRealtimeAggregationOp() == aggrMetric.getRealtimeAggregationOp()) continue;
                        aggrMetric.setRealtimeAggregationOp(m.getRealtimeAggregationOp());
                    }
                    aggrRow.clear();
                }
                Set metrics = e.getMetrics();
                metrics.remove(aggrMetric);
                metrics.add(aggrMetric);
            }
            return e;
        }

        public TimelineEntity aggregateAllTo(TimelineEntity e, String aggregationGroupId) {
            for (TimelineMetric m : this.aggregateTable.keySet()) {
                this.aggregateTo(m, e, aggregationGroupId);
            }
            return e;
        }
    }
}

