/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import org.apache.hadoop.classification.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CachedSASToken {
    public static final Logger LOG = LoggerFactory.getLogger(CachedSASToken.class);
    private final long minExpirationInSeconds;
    private String sasToken;
    private OffsetDateTime sasExpiry;

    public CachedSASToken() {
        this(120L);
    }

    public CachedSASToken(long minExpirationInSeconds) {
        this.minExpirationInSeconds = minExpirationInSeconds;
    }

    private static boolean isNearExpiry(OffsetDateTime expiry, long minExpiryInSeconds) {
        if (expiry == OffsetDateTime.MIN) {
            return true;
        }
        OffsetDateTime utcNow = OffsetDateTime.now(ZoneOffset.UTC);
        return utcNow.until(expiry, ChronoUnit.SECONDS) <= minExpiryInSeconds;
    }

    private static OffsetDateTime getExpiry(String token) {
        if (token == null) {
            return OffsetDateTime.MIN;
        }
        String signedExpiry = "se=";
        int signedExpiryLen = 3;
        int start = token.indexOf(signedExpiry);
        if (start == -1) {
            return OffsetDateTime.MIN;
        }
        int end = token.indexOf("&", start += signedExpiryLen);
        String seValue = end == -1 ? token.substring(start) : token.substring(start, end);
        try {
            seValue = URLDecoder.decode(seValue, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error("Error decoding se query parameter ({}) from SAS.", (Object)seValue, (Object)ex);
            return OffsetDateTime.MIN;
        }
        OffsetDateTime seDate = OffsetDateTime.MIN;
        try {
            seDate = OffsetDateTime.parse(seValue, DateTimeFormatter.ISO_DATE_TIME);
        }
        catch (DateTimeParseException ex) {
            LOG.error("Error parsing se query parameter ({}) from SAS.", (Object)seValue, (Object)ex);
        }
        String signedKeyExpiry = "ske=";
        int signedKeyExpiryLen = 4;
        start = token.indexOf(signedKeyExpiry);
        if (start == -1) {
            return seDate;
        }
        end = token.indexOf("&", start += signedKeyExpiryLen);
        String skeValue = end == -1 ? token.substring(start) : token.substring(start, end);
        try {
            skeValue = URLDecoder.decode(skeValue, "utf-8");
        }
        catch (UnsupportedEncodingException ex) {
            LOG.error("Error decoding ske query parameter ({}) from SAS.", (Object)skeValue, (Object)ex);
            return OffsetDateTime.MIN;
        }
        OffsetDateTime skeDate = OffsetDateTime.MIN;
        try {
            skeDate = OffsetDateTime.parse(skeValue, DateTimeFormatter.ISO_DATE_TIME);
        }
        catch (DateTimeParseException ex) {
            LOG.error("Error parsing ske query parameter ({}) from SAS.", (Object)skeValue, (Object)ex);
            return OffsetDateTime.MIN;
        }
        return skeDate.isBefore(seDate) ? skeDate : seDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String token) {
        if (token == this.sasToken) {
            return;
        }
        OffsetDateTime newExpiry = CachedSASToken.getExpiry(token);
        boolean isInvalid = CachedSASToken.isNearExpiry(newExpiry, this.minExpirationInSeconds);
        CachedSASToken cachedSASToken = this;
        synchronized (cachedSASToken) {
            if (isInvalid) {
                this.sasToken = null;
                this.sasExpiry = OffsetDateTime.MIN;
            } else {
                this.sasToken = token;
                this.sasExpiry = newExpiry;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        OffsetDateTime exp;
        String token;
        if (this.sasToken == null) {
            return null;
        }
        CachedSASToken cachedSASToken = this;
        synchronized (cachedSASToken) {
            token = this.sasToken;
            exp = this.sasExpiry;
        }
        boolean isInvalid = CachedSASToken.isNearExpiry(exp, this.minExpirationInSeconds);
        return isInvalid ? null : token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setForTesting(String token, OffsetDateTime expiry) {
        CachedSASToken cachedSASToken = this;
        synchronized (cachedSASToken) {
            this.sasToken = token;
            this.sasExpiry = expiry;
        }
    }
}

