/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.snapshot.SnapshotFileCache;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, LargeTests.class})
public class TestSnapshotFileCache {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotFileCache.class);
    protected static final Logger LOG = LoggerFactory.getLogger(TestSnapshotFileCache.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    protected static final long PERIOD = Long.MAX_VALUE;
    protected static FileSystem fs;
    protected static Path rootDir;
    protected static Path snapshotDir;
    protected static Configuration conf;
    protected static FileSystem workingFs;
    protected static Path workingDir;

    protected static void initCommon() throws Exception {
        UTIL.startMiniDFSCluster(1);
        fs = UTIL.getDFSCluster().getFileSystem();
        rootDir = UTIL.getDefaultRootDirPath();
        snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir((Path)rootDir);
        conf = UTIL.getConfiguration();
    }

    @BeforeClass
    public static void startCluster() throws Exception {
        TestSnapshotFileCache.initCommon();
        workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir((Path)rootDir, (Configuration)conf);
        workingFs = workingDir.getFileSystem(conf);
    }

    @AfterClass
    public static void stopCluster() throws Exception {
        UTIL.shutdownMiniDFSCluster();
    }

    @After
    public void cleanupFiles() throws Exception {
        fs.delete(snapshotDir, true);
    }

    @Test
    public void testLoadAndDelete() throws IOException {
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, workingFs, workingDir, Long.MAX_VALUE, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        this.createAndTestSnapshotV1(cache, "snapshot1a", false, true, false);
        this.createAndTestSnapshotV1(cache, "snapshot1b", true, true, false);
        this.createAndTestSnapshotV2(cache, "snapshot2a", false, true, false);
        this.createAndTestSnapshotV2(cache, "snapshot2b", true, true, false);
    }

    @Test
    public void testReloadModifiedDirectory() throws IOException {
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, workingFs, workingDir, Long.MAX_VALUE, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        this.createAndTestSnapshotV1(cache, "snapshot1", false, true, false);
        this.createAndTestSnapshotV1(cache, "snapshot1", false, false, false);
        this.createAndTestSnapshotV2(cache, "snapshot2", false, true, false);
        this.createAndTestSnapshotV2(cache, "snapshot2", false, false, false);
    }

    @Test
    public void testSnapshotTempDirReload() throws IOException {
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, workingFs, workingDir, Long.MAX_VALUE, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        this.createAndTestSnapshotV1(cache, "snapshot0v1", false, false, false);
        this.createAndTestSnapshotV1(cache, "snapshot0v2", false, false, false);
    }

    @Test
    public void testCacheUpdatedWhenLastModifiedOfSnapDirNotUpdated() throws IOException {
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, workingFs, workingDir, Long.MAX_VALUE, 10000000L, "test-snapshot-file-cache-refresh", (SnapshotFileCache.SnapshotFileInspector)new SnapshotFiles());
        this.createAndTestSnapshotV1(cache, "snapshot1v1", false, false, true);
        this.createAndTestSnapshotV1(cache, "snapshot1v2", false, false, true);
        this.createAndTestSnapshotV2(cache, "snapshot2v1", true, false, true);
        this.createAndTestSnapshotV2(cache, "snapshot2v2", true, false, true);
    }

    @Test
    public void testWeNeverCacheTmpDirAndLoadIt() throws Exception {
        final AtomicInteger count = new AtomicInteger(0);
        long period = Long.MAX_VALUE;
        SnapshotFileCache cache = new SnapshotFileCache(fs, rootDir, workingFs, workingDir, period, 10000000L, "test-snapshot-file-cache-refresh", new SnapshotFiles()){

            List<String> getSnapshotsInProgress() throws IOException {
                List result = super.getSnapshotsInProgress();
                count.incrementAndGet();
                return result;
            }

            public void triggerCacheRefreshForTesting() {
                super.triggerCacheRefreshForTesting();
            }
        };
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder complete = this.createAndTestSnapshotV1(cache, "snapshot", false, false, false);
        int countBeforeCheck = count.get();
        CommonFSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Logger)LOG);
        List<FileStatus> allStoreFiles = this.getStoreFilesForSnapshot(complete);
        Iterable deletableFiles = cache.getUnreferencedFiles(allStoreFiles, null);
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)deletableFiles));
        Assert.assertEquals((long)0L, (long)(count.get() - countBeforeCheck));
        FileStatus randomFile = this.mockStoreFile(UTIL.getRandomUUID().toString());
        allStoreFiles.add(randomFile);
        deletableFiles = cache.getUnreferencedFiles(allStoreFiles, null);
        Assert.assertEquals((Object)randomFile, (Object)Iterables.getOnlyElement((Iterable)deletableFiles));
        Assert.assertEquals((long)1L, (long)(count.get() - countBeforeCheck));
    }

    private List<FileStatus> getStoreFilesForSnapshot(SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder) throws IOException {
        final ArrayList allStoreFiles = Lists.newArrayList();
        SnapshotReferenceUtil.visitReferencedFiles((Configuration)conf, (FileSystem)fs, (Path)builder.getSnapshotsDir(), (SnapshotReferenceUtil.SnapshotVisitor)new SnapshotReferenceUtil.SnapshotVisitor(){

            public void storeFile(RegionInfo regionInfo, String familyName, SnapshotProtos.SnapshotRegionManifest.StoreFile storeFile) throws IOException {
                FileStatus status = TestSnapshotFileCache.this.mockStoreFile(storeFile.getName());
                allStoreFiles.add(status);
            }
        });
        return allStoreFiles;
    }

    private FileStatus mockStoreFile(String storeFileName) {
        FileStatus status = (FileStatus)Mockito.mock(FileStatus.class);
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getName()).thenReturn((Object)storeFileName);
        Mockito.when((Object)status.getPath()).thenReturn((Object)path);
        return status;
    }

    private SnapshotTestingUtils.SnapshotMock.SnapshotBuilder createAndTestSnapshotV1(SnapshotFileCache cache, String name, boolean tmp, boolean removeOnExit, boolean setFolderTime) throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(conf, fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV1(name, name);
        this.createAndTestSnapshot(cache, builder, tmp, removeOnExit, setFolderTime);
        return builder;
    }

    private void createAndTestSnapshotV2(SnapshotFileCache cache, String name, boolean tmp, boolean removeOnExit, boolean setFolderTime) throws IOException {
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(conf, fs, rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2(name, name);
        this.createAndTestSnapshot(cache, builder, tmp, removeOnExit, setFolderTime);
    }

    private void createAndTestSnapshot(SnapshotFileCache cache, SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder, boolean tmp, boolean removeOnExit, boolean setFolderTime) throws IOException {
        ArrayList<Path> files = new ArrayList<Path>();
        for (int i = 0; i < 3; ++i) {
            for (Path filePath : builder.addRegion()) {
                if (tmp) {
                    CommonFSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Logger)LOG);
                    Assert.assertFalse((String)("Cache didn't find " + filePath), (boolean)TestSnapshotFileCache.contains(TestSnapshotFileCache.getNonSnapshotFiles(cache, filePath), filePath));
                }
                files.add(filePath);
            }
        }
        if (!tmp) {
            builder.commit();
        }
        if (setFolderTime) {
            fs.setTimes(snapshotDir, 0L, -1L);
        }
        for (Path path : files) {
            Assert.assertFalse((String)("Cache didn't find " + path), (boolean)TestSnapshotFileCache.contains(TestSnapshotFileCache.getNonSnapshotFiles(cache, path), path));
        }
        CommonFSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Logger)LOG);
        if (removeOnExit) {
            LOG.debug("Deleting snapshot.");
            builder.getSnapshotsDir().getFileSystem(conf).delete(builder.getSnapshotsDir(), true);
            CommonFSUtils.logFileSystemState((FileSystem)fs, (Path)rootDir, (Logger)LOG);
            cache.triggerCacheRefreshForTesting();
            for (Path filePath : files) {
                Assert.assertTrue((String)("Cache found '" + filePath + "', but it shouldn't have."), (boolean)TestSnapshotFileCache.contains(TestSnapshotFileCache.getNonSnapshotFiles(cache, filePath), filePath));
            }
        }
    }

    private static boolean contains(Iterable<FileStatus> files, Path filePath) {
        for (FileStatus status : files) {
            LOG.debug("debug in contains, 3.1: " + status.getPath() + " filePath:" + filePath);
            if (!filePath.equals((Object)status.getPath())) continue;
            return true;
        }
        return false;
    }

    private static Iterable<FileStatus> getNonSnapshotFiles(SnapshotFileCache cache, Path storeFile) throws IOException {
        return cache.getUnreferencedFiles(Arrays.asList(CommonFSUtils.listStatus((FileSystem)fs, (Path)storeFile.getParent())), null);
    }

    class SnapshotFiles
    implements SnapshotFileCache.SnapshotFileInspector {
        SnapshotFiles() {
        }

        public Collection<String> filesUnderSnapshot(FileSystem workingFs, Path snapshotDir) throws IOException {
            HashSet<String> files = new HashSet<String>();
            files.addAll(SnapshotReferenceUtil.getHFileNames((Configuration)conf, (FileSystem)workingFs, (Path)snapshotDir));
            return files;
        }
    }
}

