/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.mqtt;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CertificateFormatter {
    public static String formatCertificateChain(String input) {
        if (input == null || input.trim().isEmpty()) {
            return input;
        }
        String normalized = CertificateFormatter.normalizeInput(input);
        List<String> certificates = CertificateFormatter.extractCertificates(normalized);
        if (certificates.isEmpty()) {
            return CertificateFormatter.formatAsSingleCertificate(normalized);
        }
        StringBuilder formattedChain = new StringBuilder();
        for (String cert : certificates) {
            if (cert.trim().isEmpty()) continue;
            String formatted = CertificateFormatter.formatPemBlock(cert);
            formattedChain.append(formatted).append("\n");
        }
        return formattedChain.toString().trim();
    }

    private static String normalizeInput(String input) {
        return input.replace("\r\n", "\n").replace("\r", "\n").replaceAll("\\s*\\\\n\\s*", "\n").replaceAll("(?m)^\\s+|\\s+$", "").trim();
    }

    private static List<String> extractCertificates(String input) {
        ArrayList<String> certificates = new ArrayList<String>();
        String regex = "(-----BEGIN\\s+[\\w\\s]+?-----)[\\s\\S]*?(-----END\\s+[\\w\\s]+?-----)";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(input);
        int lastEnd = 0;
        while (matcher.find()) {
            String gap;
            if (matcher.start() > lastEnd && !(gap = input.substring(lastEnd, matcher.start())).trim().isEmpty()) {
                certificates.add(gap);
            }
            certificates.add(matcher.group());
            lastEnd = matcher.end();
        }
        if (lastEnd < input.length()) {
            certificates.add(input.substring(lastEnd));
        }
        return certificates;
    }

    private static String formatPemBlock(String block) {
        try {
            Pattern pattern = Pattern.compile("(-----BEGIN\\s+[\\w\\s]+?-----)(.*?)(-----END\\s+[\\w\\s]+?-----)", 34);
            Matcher matcher = pattern.matcher(block);
            if (matcher.find()) {
                String cleanBody;
                String header = matcher.group(1).trim();
                String body = matcher.group(2);
                String footer = matcher.group(3).trim();
                if (body == null) {
                    body = "";
                }
                if ((cleanBody = body.replaceAll("\\s", "").replaceAll("\"", "").trim()).isEmpty() && body != null && !body.trim().isEmpty()) {
                    cleanBody = body.replaceAll("[^a-zA-Z0-9+/=]", "").trim();
                }
                String formattedBody = CertificateFormatter.formatBase64Body(cleanBody);
                return header + "\n" + formattedBody + "\n" + footer;
            }
            return CertificateFormatter.formatAsCertificate(block);
        }
        catch (Exception e) {
            return block;
        }
    }

    private static String formatAsCertificate(String content) {
        String cleanContent = content.replaceAll("[^a-zA-Z0-9+/=]", "").trim();
        if (cleanContent.isEmpty()) {
            return content;
        }
        String formattedBody = CertificateFormatter.formatBase64Body(cleanContent);
        if (cleanContent.toLowerCase().contains("private")) {
            if (cleanContent.startsWith("MII") || cleanContent.length() > 1000) {
                return "-----BEGIN PRIVATE KEY-----\n" + formattedBody + "\n-----END PRIVATE KEY-----";
            }
            return "-----BEGIN RSA PRIVATE KEY-----\n" + formattedBody + "\n-----END RSA PRIVATE KEY-----";
        }
        return "-----BEGIN CERTIFICATE-----\n" + formattedBody + "\n-----END CERTIFICATE-----";
    }

    private static String formatAsSingleCertificate(String input) {
        String cleanContent = input.replaceAll("[^a-zA-Z0-9+/=]", "").trim();
        return CertificateFormatter.formatAsCertificate(cleanContent);
    }

    private static String formatBase64Body(String body) {
        StringBuilder formatted = new StringBuilder();
        int index = 0;
        while (index < body.length()) {
            int end = Math.min(index + 64, body.length());
            formatted.append(body.substring(index, end));
            if (end < body.length()) {
                formatted.append("\n");
            }
            index = end;
        }
        return formatted.toString().trim();
    }

    public static String formatPrivateKey(String input) {
        if (input == null || input.trim().isEmpty()) {
            return input;
        }
        String normalized = CertificateFormatter.normalizeInput(input);
        if (CertificateFormatter.isPemEncapsulated(normalized)) {
            return CertificateFormatter.formatPemBlock(normalized);
        }
        return CertificateFormatter.formatAsCertificate(normalized);
    }

    private static boolean isPemEncapsulated(String block) {
        return block.contains("-----BEGIN") && block.contains("-----END");
    }
}

