/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.linemerge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.operation.linemerge.EdgeString;
import org.locationtech.jts.operation.linemerge.LineMergeDirectedEdge;
import org.locationtech.jts.operation.linemerge.LineMergeGraph;
import org.locationtech.jts.planargraph.GraphComponent;
import org.locationtech.jts.planargraph.Node;
import org.locationtech.jts.util.Assert;

public class LineMerger {
    private LineMergeGraph graph = new LineMergeGraph();
    private Collection mergedLineStrings = null;
    private GeometryFactory factory = null;
    private Collection edgeStrings = null;

    public void add(Geometry geometry) {
        geometry.apply(new GeometryComponentFilter(){

            @Override
            public void filter(Geometry component) {
                if (component instanceof LineString) {
                    LineMerger.this.add((LineString)component);
                }
            }
        });
    }

    public void add(Collection geometries) {
        this.mergedLineStrings = null;
        for (Geometry geometry : geometries) {
            this.add(geometry);
        }
    }

    private void add(LineString lineString) {
        if (this.factory == null) {
            this.factory = lineString.getFactory();
        }
        this.graph.addEdge(lineString);
    }

    private void merge() {
        if (this.mergedLineStrings != null) {
            return;
        }
        GraphComponent.setMarked(this.graph.nodeIterator(), false);
        GraphComponent.setMarked(this.graph.edgeIterator(), false);
        this.edgeStrings = new ArrayList();
        this.buildEdgeStringsForObviousStartNodes();
        this.buildEdgeStringsForIsolatedLoops();
        this.mergedLineStrings = new ArrayList();
        for (EdgeString edgeString : this.edgeStrings) {
            this.mergedLineStrings.add(edgeString.toLineString());
        }
    }

    private void buildEdgeStringsForObviousStartNodes() {
        this.buildEdgeStringsForNonDegree2Nodes();
    }

    private void buildEdgeStringsForIsolatedLoops() {
        this.buildEdgeStringsForUnprocessedNodes();
    }

    private void buildEdgeStringsForUnprocessedNodes() {
        for (Node node : this.graph.getNodes()) {
            if (node.isMarked()) continue;
            Assert.isTrue(node.getDegree() == 2);
            this.buildEdgeStringsStartingAt(node);
            node.setMarked(true);
        }
    }

    private void buildEdgeStringsForNonDegree2Nodes() {
        for (Node node : this.graph.getNodes()) {
            if (node.getDegree() == 2) continue;
            this.buildEdgeStringsStartingAt(node);
            node.setMarked(true);
        }
    }

    private void buildEdgeStringsStartingAt(Node node) {
        Iterator i = node.getOutEdges().iterator();
        while (i.hasNext()) {
            LineMergeDirectedEdge directedEdge = (LineMergeDirectedEdge)i.next();
            if (directedEdge.getEdge().isMarked()) continue;
            this.edgeStrings.add(this.buildEdgeStringStartingWith(directedEdge));
        }
    }

    private EdgeString buildEdgeStringStartingWith(LineMergeDirectedEdge start) {
        EdgeString edgeString = new EdgeString(this.factory);
        LineMergeDirectedEdge current = start;
        do {
            edgeString.add(current);
            current.getEdge().setMarked(true);
        } while ((current = current.getNext()) != null && current != start);
        return edgeString;
    }

    public Collection getMergedLineStrings() {
        this.merge();
        return this.mergedLineStrings;
    }
}

