/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.sd;

import java.io.IOException;
import java.util.List;
import org.apache.hertzbeat.collector.collect.AbstractCollect;
import org.apache.hertzbeat.common.entity.job.Metrics;
import org.apache.hertzbeat.common.entity.job.protocol.ZookeeperSdProtocol;
import org.apache.hertzbeat.common.entity.message.CollectRep;
import org.apache.hertzbeat.common.entity.sd.ConnectionConfig;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperSdCollectImpl
extends AbstractCollect {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperSdCollectImpl.class);
    private static int TIMEOUT = 30000;

    public void collect(CollectRep.MetricsData.Builder builder, Metrics metrics) {
        ZookeeperSdProtocol zookeeperSdProtocol = metrics.getZookeeper_sd();
        String url = zookeeperSdProtocol.getUrl();
        String pathPrefix = zookeeperSdProtocol.getPathPrefix();
        try (ZooKeeper zk = new ZooKeeper(url, TIMEOUT, event -> {});){
            List children = zk.getChildren(pathPrefix, false);
            List<ConnectionConfig> connectionConfigs = children.stream().map(node -> {
                String[] split = node.split(":");
                if (split.length != 2) {
                    log.warn("Node format is incorrect: {}, expected format is 'host:port'", node);
                }
                return new ConnectionConfig(split[0], split[1]);
            }).toList();
            connectionConfigs.forEach(config -> {
                CollectRep.ValueRow valueRow = CollectRep.ValueRow.newBuilder().addColumn(config.getHost()).addColumn(config.getPort()).build();
                builder.addValueRow(valueRow);
            });
        }
        catch (IOException e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.error("Failed to connect to Zookeeper: {}", (Object)errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        catch (InterruptedException e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.error("Zookeeper connection interrupted: {}", (Object)errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
        catch (KeeperException e) {
            String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
            log.error("Zookeeper operation failed: {}", (Object)errorMsg);
            builder.setCode(CollectRep.Code.FAIL);
            builder.setMsg(errorMsg);
        }
    }

    public void preCheck(Metrics metrics) throws IllegalArgumentException {
        if (metrics.getZookeeper_sd() == null) {
            throw new IllegalArgumentException("Zookeeper SD configuration cannot be null");
        }
        if (metrics.getZookeeper_sd().getUrl() == null || metrics.getZookeeper_sd().getUrl().isEmpty()) {
            throw new IllegalArgumentException("Zookeeper URL cannot be null or empty");
        }
        if (metrics.getZookeeper_sd().getPathPrefix() == null || metrics.getZookeeper_sd().getPathPrefix().isEmpty()) {
            throw new IllegalArgumentException("Zookeeper path prefix cannot be null or empty");
        }
    }

    public String supportProtocol() {
        return "zookeeper_sd";
    }
}

