/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.PppDllProtocol;
import org.pcap4j.util.ByteArrays;

abstract class AbstractPppPacket
extends AbstractPacket {
    private static final long serialVersionUID = 9184646119975504414L;
    private final Packet payload;
    private final byte[] pad;

    protected AbstractPppPacket(byte[] rawData, int offset, int length, AbstractPppHeader header) throws IllegalRawDataException {
        int payloadAndPadLength = length - header.length();
        if (payloadAndPadLength > 0) {
            int payloadOffset = offset + header.length();
            this.payload = PacketFactories.getFactory(Packet.class, PppDllProtocol.class).newInstance(rawData, payloadOffset, payloadAndPadLength, header.getProtocol());
            int padLength = payloadAndPadLength - this.payload.length();
            this.pad = padLength > 0 ? ByteArrays.getSubArray(rawData, payloadOffset + this.payload.length(), padLength) : new byte[0];
        } else {
            this.payload = null;
            this.pad = new byte[0];
        }
    }

    protected AbstractPppPacket(Builder builder) {
        if (builder == null || builder.protocol == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.protocol: ").append(builder.protocol);
            throw new NullPointerException(sb.toString());
        }
        Packet packet = this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        if (builder.pad != null && builder.pad.length != 0) {
            this.pad = new byte[builder.pad.length];
            System.arraycopy(builder.pad, 0, this.pad, 0, builder.pad.length);
        } else {
            this.pad = new byte[0];
        }
    }

    @Override
    public abstract AbstractPppHeader getHeader();

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    public byte[] getPad() {
        byte[] copy = new byte[this.pad.length];
        System.arraycopy(this.pad, 0, copy, 0, this.pad.length);
        return copy;
    }

    @Override
    protected int calcLength() {
        int length = super.calcLength();
        return length += this.pad.length;
    }

    @Override
    protected byte[] buildRawData() {
        byte[] rawData = super.buildRawData();
        if (this.pad.length != 0) {
            System.arraycopy(this.pad, 0, rawData, rawData.length - this.pad.length, this.pad.length);
        }
        return rawData;
    }

    @Override
    protected String buildString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getHeader().toString());
        if (this.payload != null) {
            sb.append(this.payload.toString());
        }
        if (this.pad.length != 0) {
            String ls = System.getProperty("line.separator");
            sb.append("[PPP Pad (").append(this.pad.length).append(" bytes)]").append(ls).append("  Hex stream: ").append(ByteArrays.toHexString(this.pad, " ")).append(ls);
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            AbstractPppPacket other = (AbstractPppPacket)obj;
            return Arrays.equals(this.pad, other.pad);
        }
        return false;
    }

    @Override
    protected int calcHashCode() {
        return 31 * super.calcHashCode() + Arrays.hashCode(this.pad);
    }

    static abstract class AbstractPppHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -9126636226651383452L;
        private static final int PROTOCOL_OFFSET = 0;
        private static final int PROTOCOL_SIZE = 2;
        static final int PPP_HEADER_SIZE = 2;
        private final PppDllProtocol protocol;

        protected AbstractPppHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 2) {
                this.protocol = null;
            } else {
                try {
                    this.protocol = PppDllProtocol.getInstance(ByteArrays.getShort(rawData, 0 + offset));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalRawDataException(e);
                }
            }
        }

        protected AbstractPppHeader(Builder builder) {
            this.protocol = builder.protocol;
        }

        public PppDllProtocol getProtocol() {
            return this.protocol;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Short)this.protocol.value()));
            return rawFields;
        }

        @Override
        public int length() {
            return 2;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[PPP Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Protocol: ").append(this.protocol).append(ls);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            AbstractPppHeader other = (AbstractPppHeader)obj;
            return this.protocol.equals(other.protocol);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.protocol.hashCode();
            return result;
        }
    }

    static abstract class Builder
    extends AbstractPacket.AbstractBuilder {
        private PppDllProtocol protocol;
        private Packet.Builder payloadBuilder;
        private byte[] pad;

        public Builder() {
        }

        protected Builder(AbstractPppPacket packet) {
            this.protocol = packet.getHeader().protocol;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
            this.pad = packet.pad;
        }

        public Builder protocol(PppDllProtocol protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder pad(byte[] pad) {
            this.pad = pad;
            return this;
        }
    }
}

