/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit.functions;

import java.util.function.Function;
import java.util.stream.IntStream;

public final class SquareRootFunction
implements Function<Integer, Integer> {
    static final int[] lookup = new int[1000];
    private static final SquareRootFunction INSTANCE;

    public static Function<Integer, Integer> create(int baseline) {
        return INSTANCE.andThen(t -> Math.max(baseline, t));
    }

    @Override
    public Integer apply(Integer t) {
        return t < 1000 ? lookup[t] : (int)Math.sqrt(t.intValue());
    }

    static {
        IntStream.range(0, 1000).forEach(i -> {
            SquareRootFunction.lookup[i] = Math.max(1, (int)Math.sqrt(i));
        });
        INSTANCE = new SquareRootFunction();
    }
}

