/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.NativeTimestampFinder;
import io.questdb.cairo.ParquetTimestampFinder;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TimestampFinder;
import io.questdb.cairo.sql.PartitionFrame;
import io.questdb.cairo.sql.PartitionFrameCursor;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.parquet.PartitionDecoder;
import io.questdb.griffin.model.RuntimeIntrinsicIntervalModel;
import io.questdb.std.LongList;
import io.questdb.std.Misc;

public abstract class AbstractIntervalPartitionFrameCursor
implements PartitionFrameCursor {
    protected final IntervalPartitionFrame frame = new IntervalPartitionFrame();
    protected final RuntimeIntrinsicIntervalModel intervalModel;
    protected final PartitionDecoder parquetDecoder = new PartitionDecoder();
    protected final int timestampIndex;
    private final NativeTimestampFinder nativeTimestampFinder = new NativeTimestampFinder();
    private final ParquetTimestampFinder parquetTimestampFinder;
    protected LongList intervals;
    protected int intervalsHi;
    protected int intervalsLo;
    protected int partitionHi;
    protected long partitionLimit;
    protected int partitionLo;
    protected TableReader reader;
    protected long sizeSoFar = 0L;
    private int initialIntervalsHi;
    private int initialIntervalsLo;
    private int initialPartitionHi;
    private int initialPartitionLo;

    public AbstractIntervalPartitionFrameCursor(RuntimeIntrinsicIntervalModel intervalModel, int timestampIndex) {
        assert (timestampIndex > -1);
        this.intervalModel = intervalModel;
        this.timestampIndex = timestampIndex;
        this.parquetTimestampFinder = new ParquetTimestampFinder(this.parquetDecoder);
    }

    @Override
    public void calculateSize(RecordCursor.Counter counter) {
        int intervalsLo1 = this.intervalsLo;
        int intervalsHi1 = this.intervalsHi;
        int partitionLo1 = this.partitionLo;
        int partitionHi1 = this.partitionHi;
        long partitionLimit1 = this.partitionLimit;
        long size = this.sizeSoFar;
        while (intervalsLo1 < intervalsHi1 && partitionLo1 < partitionHi1) {
            long rowCount;
            try {
                rowCount = this.reader.getPartitionRowCountFromMetadata(partitionLo1);
            }
            catch (DataUnavailableException e) {
                Misc.free(e.getEvent());
                return;
            }
            if (rowCount > 0L) {
                long hi;
                TimestampFinder timestampFinder = this.initTimestampFinder(partitionLo1, rowCount);
                long intervalLo = this.intervals.getQuick(intervalsLo1 * 2);
                long intervalHi = this.intervals.getQuick(intervalsLo1 * 2 + 1);
                long partitionTimestampLoApprox = timestampFinder.minTimestampApproxFromMetadata();
                if (partitionTimestampLoApprox > intervalHi) {
                    ++intervalsLo1;
                    continue;
                }
                long partitionTimestampHiApprox = timestampFinder.maxTimestampApproxFromMetadata();
                if (partitionTimestampHiApprox < intervalLo) {
                    partitionLimit1 = 0L;
                    ++partitionLo1;
                    continue;
                }
                this.reader.openPartition(partitionLo1);
                timestampFinder.prepare();
                long partitionTimestampLoExact = timestampFinder.minTimestampExact();
                if (partitionTimestampLoExact > intervalHi) {
                    ++intervalsLo1;
                    continue;
                }
                long partitionTimestampHiExact = timestampFinder.maxTimestampExact();
                if (partitionTimestampHiExact < intervalLo) {
                    partitionLimit1 = 0L;
                    ++partitionLo1;
                    continue;
                }
                long lo = partitionTimestampLoExact >= intervalLo ? 0L : timestampFinder.findTimestamp(intervalLo - 1L, partitionLimit1 == -1L ? 0L : partitionLimit1, rowCount - 1L) + 1L;
                if (lo < (hi = timestampFinder.findTimestamp(intervalHi, lo, rowCount - 1L) + 1L)) {
                    size += hi - lo;
                    if (hi == rowCount) {
                        partitionLimit1 = 0L;
                        ++partitionLo1;
                        continue;
                    }
                    partitionLimit1 = hi;
                    ++intervalsLo1;
                    continue;
                }
                partitionLimit1 = hi;
                ++intervalsLo1;
                continue;
            }
            ++partitionLo1;
        }
        counter.add(size - this.sizeSoFar);
    }

    @Override
    public void close() {
        this.reader = Misc.free(this.reader);
        Misc.free(this.parquetTimestampFinder);
        Misc.free(this.parquetDecoder);
        this.nativeTimestampFinder.clear();
    }

    @Override
    public SymbolMapReader getSymbolTable(int columnIndex) {
        return this.reader.getSymbolMapReader(columnIndex);
    }

    @Override
    public TableReader getTableReader() {
        return this.reader;
    }

    public int getTimestampIndex() {
        return this.timestampIndex;
    }

    @Override
    public StaticSymbolTable newSymbolTable(int columnIndex) {
        return this.reader.newSymbolTable(columnIndex);
    }

    public AbstractIntervalPartitionFrameCursor of(TableReader reader, SqlExecutionContext sqlExecutionContext) throws SqlException {
        this.intervals = this.intervalModel.calculateIntervals(sqlExecutionContext);
        this.calculateRanges(reader, this.intervals);
        this.reader = reader;
        return this;
    }

    @Override
    public boolean reload() {
        if (this.reader != null && this.reader.reload()) {
            this.calculateRanges(this.reader, this.intervals);
            return true;
        }
        return false;
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    public boolean supportsSizeCalculation() {
        return true;
    }

    @Override
    public void toTop() {
        this.parquetTimestampFinder.clear();
        this.nativeTimestampFinder.clear();
        this.intervalsLo = this.initialIntervalsLo;
        this.intervalsHi = this.initialIntervalsHi;
        this.partitionLo = this.initialPartitionLo;
        this.partitionHi = this.initialPartitionHi;
        this.sizeSoFar = 0L;
    }

    private void calculateRanges(TableReader reader, LongList intervals) {
        if (intervals.size() > 0) {
            if (PartitionBy.isPartitioned(reader.getPartitionedBy())) {
                this.cullIntervals(reader, intervals);
                if (this.initialIntervalsLo < this.initialIntervalsHi) {
                    this.cullPartitions(reader, intervals);
                }
            } else {
                this.initialIntervalsLo = 0;
                this.initialIntervalsHi = intervals.size() / 2;
                this.initialPartitionLo = 0;
                this.initialPartitionHi = reader.getPartitionCount();
            }
        } else {
            this.initialIntervalsLo = 0;
            this.initialIntervalsHi = 0;
            this.initialPartitionLo = 0;
            this.initialPartitionHi = 0;
        }
        this.toTop();
    }

    private void cullIntervals(TableReader reader, LongList intervals) {
        int intervalsHi;
        int intervalsLo = intervals.binarySearch(reader.getMinTimestamp(), -1);
        if (intervalsLo < 0) {
            intervalsLo = -intervalsLo - 1;
        }
        this.initialIntervalsLo = intervalsLo / 2;
        this.initialIntervalsHi = reader.getMaxTimestamp() == intervals.getQuick(intervals.size() - 1) ? intervals.size() / 2 : (reader.getMaxTimestamp() == intervals.getQuick(0) ? 1 : ((intervalsHi = intervals.binarySearch(reader.getMaxTimestamp(), -1)) < 0 ? ((intervalsHi = -intervalsHi - 1) % 2 == 0 ? intervalsHi / 2 : intervalsHi / 2 + 1) : intervalsHi / 2 + 1));
    }

    private void cullPartitions(TableReader reader, LongList intervals) {
        long lo = intervals.getQuick(this.initialIntervalsLo * 2);
        long intervalLo = lo == Long.MIN_VALUE ? reader.floorToPartitionTimestamp(reader.getMinTimestamp()) : reader.floorToPartitionTimestamp(lo);
        this.initialPartitionLo = reader.getMinTimestamp() < intervalLo ? reader.getPartitionIndexByTimestamp(intervalLo) : 0;
        long intervalHi = reader.floorToPartitionTimestamp(intervals.getQuick((this.initialIntervalsHi - 1) * 2 + 1));
        this.initialPartitionHi = Math.min(reader.getPartitionCount(), reader.getPartitionIndexByTimestamp(intervalHi) + 1);
    }

    protected TimestampFinder initTimestampFinder(int partitionIndex, long rowCount) {
        if (this.reader.getPartitionFormatFromMetadata(partitionIndex) == 1) {
            return this.parquetTimestampFinder.of(this.reader, partitionIndex, this.timestampIndex);
        }
        return this.nativeTimestampFinder.of(this.reader, partitionIndex, this.timestampIndex, rowCount);
    }

    protected static class IntervalPartitionFrame
    implements PartitionFrame {
        protected byte format;
        protected PartitionDecoder parquetDecoder;
        protected int partitionIndex;
        protected long rowHi;
        protected long rowLo;

        protected IntervalPartitionFrame() {
        }

        @Override
        public PartitionDecoder getParquetDecoder() {
            return this.parquetDecoder;
        }

        @Override
        public byte getPartitionFormat() {
            return this.format;
        }

        @Override
        public int getPartitionIndex() {
            return this.partitionIndex;
        }

        @Override
        public long getRowHi() {
            return this.rowHi;
        }

        @Override
        public long getRowLo() {
            return this.rowLo;
        }
    }
}

