/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.AbstractFullPartitionFrameCursor;
import io.questdb.cairo.sql.PartitionFrame;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.engine.table.parquet.PartitionDecoder;

public class FullBwdPartitionFrameCursor
extends AbstractFullPartitionFrameCursor {
    @Override
    public void calculateSize(RecordCursor.Counter counter) {
        while (this.partitionIndex > -1) {
            long hi = this.reader.openPartition(this.partitionIndex);
            if (hi > 0L) {
                counter.add(hi);
            }
            --this.partitionIndex;
        }
    }

    @Override
    public PartitionFrame next(long skipTarget) {
        while (this.partitionIndex > -1) {
            long hi = this.reader.getPartitionRowCountFromMetadata(this.partitionIndex);
            if (hi < 1L) {
                --this.partitionIndex;
                continue;
            }
            this.frame.partitionIndex = this.partitionIndex--;
            this.frame.rowLo = 0L;
            this.frame.rowHi = hi;
            if (hi <= skipTarget) {
                return this.frame;
            }
            return this.nextSlow();
        }
        return null;
    }

    @Override
    public boolean supportsSizeCalculation() {
        return true;
    }

    @Override
    public void toTop() {
        this.partitionIndex = this.partitionHi - 1;
    }

    private AbstractFullPartitionFrameCursor.FullTablePartitionFrame nextSlow() {
        this.reader.openPartition(this.partitionIndex);
        --this.partitionIndex;
        byte format = this.reader.getPartitionFormat(this.frame.partitionIndex);
        if (format == 1) {
            long addr = this.reader.getParquetAddr(this.frame.partitionIndex);
            assert (addr != 0L);
            long parquetSize = this.reader.getParquetFileSize(this.frame.partitionIndex);
            assert (parquetSize > 0L);
            if (this.parquetDecoder == null) {
                this.parquetDecoder = new PartitionDecoder();
            }
            this.parquetDecoder.of(addr, parquetSize, 65);
            this.frame.format = 1;
            this.frame.parquetDecoder = this.parquetDecoder;
            return this.frame;
        }
        assert (format == 0);
        this.frame.format = 0;
        this.frame.parquetDecoder = null;
        return this.frame;
    }
}

