/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.RecordSinkSPI;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.VarcharTypeDriver;
import io.questdb.cairo.arr.ArrayTypeDriver;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.std.BinarySequence;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.Utf8Sequence;

public final class SingleRecordSink
implements RecordSinkSPI,
Mutable,
Reopenable {
    private static final int INITIAL_CAPACITY_BYTES = 8;
    private final long maxHeapSize;
    private final int memoryTag;
    private long appendAddress;
    private long heapLimit;
    private long heapStart;

    public SingleRecordSink(long maxHeapSizeBytes, int memoryTag) {
        this.memoryTag = memoryTag;
        this.maxHeapSize = maxHeapSizeBytes;
    }

    @Override
    public void clear() {
        this.appendAddress = this.heapStart;
    }

    @Override
    public void close() {
        if (this.appendAddress != 0L) {
            Unsafe.free(this.heapStart, this.heapLimit - this.heapStart, this.memoryTag);
            this.appendAddress = 0L;
            this.heapStart = 0L;
        }
    }

    public boolean memeq(SingleRecordSink other) {
        long thisSize = this.appendAddress - this.heapStart;
        long otherSize = other.appendAddress - other.heapStart;
        if (thisSize != otherSize) {
            return false;
        }
        return Vect.memeq(this.heapStart, other.heapStart, thisSize);
    }

    @Override
    public void putArray(ArrayView value) {
        long byteCount = ArrayTypeDriver.getPlainValueSize(value);
        this.checkCapacity(byteCount);
        ArrayTypeDriver.appendPlainValue(this.appendAddress, value);
        this.appendAddress += byteCount;
    }

    @Override
    public void putBin(BinarySequence value) {
        if (value == null) {
            this.putVarSizeNull();
        } else {
            long len = value.length() + 4L;
            if (len > Integer.MAX_VALUE) {
                throw CairoException.nonCritical().put("binary column is too large");
            }
            this.checkCapacity((int)len);
            int l = (int)(len - 4L);
            Unsafe.getUnsafe().putInt(this.appendAddress, l);
            value.copyTo(this.appendAddress + 4L, 0L, l);
            this.appendAddress += len;
        }
    }

    @Override
    public void putBool(boolean value) {
        this.checkCapacity(1L);
        Unsafe.getUnsafe().putBoolean(null, this.appendAddress, value);
        ++this.appendAddress;
    }

    @Override
    public void putByte(byte value) {
        this.checkCapacity(1L);
        Unsafe.getUnsafe().putByte(this.appendAddress, value);
        ++this.appendAddress;
    }

    @Override
    public void putChar(char value) {
        this.checkCapacity(2L);
        Unsafe.getUnsafe().putChar(this.appendAddress, value);
        this.appendAddress += 2L;
    }

    @Override
    public void putDate(long value) {
        this.checkCapacity(8L);
        Unsafe.getUnsafe().putLong(this.appendAddress, value);
        this.appendAddress += 8L;
    }

    @Override
    public void putDouble(double value) {
        this.checkCapacity(8L);
        Unsafe.getUnsafe().putDouble(this.appendAddress, value);
        this.appendAddress += 8L;
    }

    @Override
    public void putFloat(float value) {
        this.checkCapacity(4L);
        Unsafe.getUnsafe().putFloat(this.appendAddress, value);
        this.appendAddress += 4L;
    }

    @Override
    public void putIPv4(int value) {
        this.checkCapacity(4L);
        Unsafe.getUnsafe().putInt(this.appendAddress, value);
        this.appendAddress += 4L;
    }

    @Override
    public void putInt(int value) {
        this.checkCapacity(4L);
        Unsafe.getUnsafe().putInt(this.appendAddress, value);
        this.appendAddress += 4L;
    }

    @Override
    public void putInterval(Interval interval) {
        this.checkCapacity(16L);
        Unsafe.getUnsafe().putLong(this.appendAddress, interval.getLo());
        Unsafe.getUnsafe().putLong(this.appendAddress + 8L, interval.getHi());
        this.appendAddress += 16L;
    }

    @Override
    public void putLong(long value) {
        this.checkCapacity(8L);
        Unsafe.getUnsafe().putLong(this.appendAddress, value);
        this.appendAddress += 8L;
    }

    @Override
    public void putLong128(long lo, long hi) {
        this.checkCapacity(16L);
        Unsafe.getUnsafe().putLong(this.appendAddress, lo);
        Unsafe.getUnsafe().putLong(this.appendAddress + 8L, hi);
        this.appendAddress += 16L;
    }

    @Override
    public void putLong256(Long256 value) {
        this.checkCapacity(32L);
        Unsafe.getUnsafe().putLong(this.appendAddress, value.getLong0());
        Unsafe.getUnsafe().putLong(this.appendAddress + 8L, value.getLong1());
        Unsafe.getUnsafe().putLong(this.appendAddress + 16L, value.getLong2());
        Unsafe.getUnsafe().putLong(this.appendAddress + 24L, value.getLong3());
        this.appendAddress += 32L;
    }

    @Override
    public void putLong256(long l0, long l1, long l2, long l3) {
        this.checkCapacity(32L);
        Unsafe.getUnsafe().putLong(this.appendAddress, l0);
        Unsafe.getUnsafe().putLong(this.appendAddress + 8L, l1);
        Unsafe.getUnsafe().putLong(this.appendAddress + 16L, l2);
        Unsafe.getUnsafe().putLong(this.appendAddress + 24L, l3);
        this.appendAddress += 32L;
    }

    @Override
    public void putRecord(Record value) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void putShort(short value) {
        this.checkCapacity(2L);
        Unsafe.getUnsafe().putShort(this.appendAddress, value);
        this.appendAddress += 2L;
    }

    @Override
    public void putStr(CharSequence value) {
        if (value == null) {
            this.putVarSizeNull();
            return;
        }
        int len = value.length();
        this.checkCapacity(((long)len << 1) + 4L);
        Unsafe.getUnsafe().putInt(this.appendAddress, len);
        this.appendAddress += 4L;
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putChar(this.appendAddress + ((long)i << 1), value.charAt(i));
        }
        this.appendAddress += (long)len << 1;
    }

    @Override
    public void putStr(CharSequence value, int lo, int hi) {
        int len = hi - lo;
        this.checkCapacity(((long)len << 1) + 4L);
        Unsafe.getUnsafe().putInt(this.appendAddress, len);
        this.appendAddress += 4L;
        for (int i = lo; i < hi; ++i) {
            Unsafe.getUnsafe().putChar(this.appendAddress + ((long)(i - lo) << 1), value.charAt(i));
        }
        this.appendAddress += (long)len << 1;
    }

    @Override
    public void putTimestamp(long value) {
        this.checkCapacity(8L);
        Unsafe.getUnsafe().putLong(this.appendAddress, value);
        this.appendAddress += 8L;
    }

    @Override
    public void putVarchar(Utf8Sequence value) {
        int byteCount = VarcharTypeDriver.getSingleMemValueByteCount(value);
        this.checkCapacity(byteCount);
        VarcharTypeDriver.appendPlainValue(this.appendAddress, value, false);
        this.appendAddress += (long)byteCount;
    }

    @Override
    public void reopen() {
        if (this.appendAddress == 0L) {
            this.heapStart = Unsafe.malloc(8L, this.memoryTag);
            this.heapLimit = this.heapStart + 8L;
        }
        this.appendAddress = this.heapStart;
    }

    @Override
    public void skip(int bytes) {
        this.checkCapacity(bytes);
        this.appendAddress += (long)bytes;
    }

    private void checkCapacity(long requiredSize) {
        if (this.appendAddress + requiredSize > this.heapLimit) {
            this.resize(requiredSize, this.appendAddress);
        }
    }

    private void putVarSizeNull() {
        this.checkCapacity(4L);
        Unsafe.getUnsafe().putInt(this.appendAddress, -1);
        this.appendAddress += 4L;
    }

    private void resize(long entrySize, long appendAddress) {
        assert (appendAddress >= this.heapStart);
        long currentCapacity = this.heapLimit - this.heapStart;
        long newCapacity = currentCapacity << 1;
        long target = appendAddress + entrySize - this.heapStart;
        if (newCapacity < target) {
            newCapacity = Numbers.ceilPow2(target);
        }
        if (newCapacity > this.maxHeapSize) {
            throw LimitOverflowException.instance().put("limit of ").put(this.maxHeapSize).put(" memory exceeded in ASOF join");
        }
        long newAddress = Unsafe.realloc(this.heapStart, currentCapacity, newCapacity, this.memoryTag);
        long delta = newAddress - this.heapStart;
        this.heapStart = newAddress;
        this.heapLimit = newAddress + newCapacity;
        this.appendAddress += delta;
    }
}

