/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.arr;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.arr.FlatArrayView;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;

public final class BorrowedFlatArrayView
implements FlatArrayView {
    private int length;
    private long ptr;
    private int size;

    @Override
    public long appendPlainDoubleValue(long addr, int offset, int length) {
        long size = (long)length * 8L;
        Vect.memcpy(addr, this.ptr + (long)offset * 8L, size);
        return addr + size;
    }

    @Override
    public void appendToMemFlat(MemoryA mem, int offset, int length) {
        assert (this.ptr != 0L);
        mem.putBlockOfBytes(this.ptr + (long)offset * 8L, (long)length * 8L);
    }

    @Override
    public double avgDouble(int offset, int length) {
        long count = Vect.countDouble(this.ptr + (long)offset * 8L, length);
        double sum = Vect.sumDouble(this.ptr + (long)offset * 8L, length);
        return sum / (double)count;
    }

    @Override
    public int countDouble(int offset, int length) {
        return (int)Vect.countDouble(this.ptr + (long)offset * 8L, length);
    }

    @Override
    public double getDoubleAtAbsIndex(int elemIndex) {
        assert (this.ptr != 0L);
        assert (elemIndex >= 0 && elemIndex < this.length);
        long addr = this.ptr + (long)elemIndex * 8L;
        return Unsafe.getUnsafe().getDouble(addr);
    }

    @Override
    public long getLongAtAbsIndex(int elemIndex) {
        assert (this.ptr != 0L);
        assert (elemIndex >= 0 && elemIndex < this.length);
        long addr = this.ptr + (long)elemIndex * 8L;
        return Unsafe.getUnsafe().getLong(addr);
    }

    @Override
    public int length() {
        return this.length;
    }

    public BorrowedFlatArrayView of(long ptr, short elemType, int length) {
        assert (ptr > 0L || length == 0) : "ptr <= 0 && length > 0";
        this.ptr = ptr;
        this.length = length;
        this.size = length * ColumnType.sizeOf(elemType);
        return this;
    }

    public BorrowedFlatArrayView of(BorrowedFlatArrayView other) {
        this.ptr = other.ptr;
        this.length = other.length;
        this.size = other.size;
        return this;
    }

    public long ptr() {
        return this.ptr;
    }

    public void reset() {
        this.ptr = 0L;
        this.length = 0;
        this.size = 0;
    }

    public void shl(long delta) {
        this.ptr -= delta;
    }

    public int size() {
        return this.size;
    }

    @Override
    public double sumDouble(int offset, int length) {
        return Vect.sumDoubleKahan(this.ptr + (long)offset * 8L, length);
    }
}

