/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.map;

import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapRecord;
import io.questdb.cairo.map.MapRecordCursor;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.map.MapValueMergeFunction;
import io.questdb.cairo.map.Unordered8MapCursor;
import io.questdb.cairo.map.Unordered8MapRecord;
import io.questdb.cairo.map.Unordered8MapValue;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.LimitOverflowException;
import io.questdb.std.BinarySequence;
import io.questdb.std.Hash;
import io.questdb.std.Interval;
import io.questdb.std.Long256;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.bytes.Bytes;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Unordered8Map
implements Map,
Reopenable {
    static final long KEY_SIZE = 8L;
    private static final long MAX_SAFE_INT_POW_2 = 0x80000000L;
    private static final int MIN_KEY_CAPACITY = 16;
    private final Unordered8MapCursor cursor;
    private final long entrySize;
    private final Key key;
    private final double loadFactor;
    private final int maxResizes;
    private final int memoryTag;
    private final Unordered8MapRecord record;
    private final Unordered8MapValue value;
    private final Unordered8MapValue value2;
    private final Unordered8MapValue value3;
    private int free;
    private boolean hasZero;
    private int initialKeyCapacity;
    private int keyCapacity;
    private long keyMemStart;
    private long mask;
    private long memLimit;
    private long memStart;
    private int nResizes;
    private int size = 0;
    private long zeroMemStart;

    public Unordered8Map(@NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes, int keyCapacity, double loadFactor, int maxResizes) {
        this(keyTypes, valueTypes, keyCapacity, loadFactor, maxResizes, 60);
    }

    Unordered8Map(@NotNull ColumnTypes keyTypes, @Nullable ColumnTypes valueTypes, int keyCapacity, double loadFactor, int maxResizes, int memoryTag) {
        assert (loadFactor > 0.0 && loadFactor < 1.0);
        try {
            this.memoryTag = memoryTag;
            this.loadFactor = loadFactor;
            this.keyCapacity = (int)((double)keyCapacity / loadFactor);
            this.keyCapacity = this.initialKeyCapacity = Math.max(Numbers.ceilPow2(this.keyCapacity), 16);
            this.maxResizes = maxResizes;
            this.mask = this.keyCapacity - 1;
            this.free = (int)((double)this.keyCapacity * loadFactor);
            this.nResizes = 0;
            int keyColumnCount = keyTypes.getColumnCount();
            long keySize = 0L;
            for (int i = 0; i < keyColumnCount; ++i) {
                int columnType = keyTypes.getColumnType(i);
                int size = ColumnType.sizeOf(columnType);
                if (size > 0) {
                    keySize += (long)size;
                    continue;
                }
                keySize = -1L;
                break;
            }
            if (keySize <= 0L || keySize > 8L) {
                throw CairoException.nonCritical().put("unexpected key size: ").put(keySize);
            }
            long valueOffset = 0L;
            long[] valueOffsets = null;
            long valueSize = 0L;
            if (valueTypes != null) {
                int valueColumnCount = valueTypes.getColumnCount();
                valueOffsets = new long[valueColumnCount];
                for (int i = 0; i < valueColumnCount; ++i) {
                    valueOffsets[i] = valueOffset;
                    int columnType = valueTypes.getColumnType(i);
                    int size = ColumnType.sizeOf(columnType);
                    if (size <= 0) {
                        throw CairoException.nonCritical().put("value type is not supported: ").put(ColumnType.nameOf(columnType));
                    }
                    valueOffset += (long)size;
                    valueSize += (long)size;
                }
            }
            this.entrySize = Bytes.align8b(8L + valueSize);
            long sizeBytes = this.entrySize * (long)this.keyCapacity;
            this.memStart = Unsafe.malloc(sizeBytes, memoryTag);
            Vect.memset(this.memStart, sizeBytes, 0);
            this.memLimit = this.memStart + sizeBytes;
            this.keyMemStart = Unsafe.malloc(8L, memoryTag);
            Unsafe.getUnsafe().putLong(this.keyMemStart, 0L);
            this.zeroMemStart = Unsafe.malloc(this.entrySize, memoryTag);
            Vect.memset(this.zeroMemStart, this.entrySize, 0);
            this.value = new Unordered8MapValue(valueSize, valueOffsets);
            this.value2 = new Unordered8MapValue(valueSize, valueOffsets);
            this.value3 = new Unordered8MapValue(valueSize, valueOffsets);
            this.record = new Unordered8MapRecord(valueSize, valueOffsets, this.value, keyTypes, valueTypes);
            this.cursor = new Unordered8MapCursor(this.record, this);
            this.key = new Key();
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public void clear() {
        this.free = (int)((double)this.keyCapacity * this.loadFactor);
        this.size = 0;
        this.nResizes = 0;
        this.hasZero = false;
        Vect.memset(this.memStart, this.memLimit - this.memStart, 0);
        Unsafe.getUnsafe().putLong(this.keyMemStart, 0L);
        Vect.memset(this.zeroMemStart, this.entrySize, 0);
    }

    @Override
    public void close() {
        if (this.memStart != 0L) {
            this.memLimit = this.memStart = Unsafe.free(this.memStart, this.memLimit - this.memStart, this.memoryTag);
            this.keyMemStart = Unsafe.free(this.keyMemStart, 8L, this.memoryTag);
            this.zeroMemStart = Unsafe.free(this.zeroMemStart, this.entrySize, this.memoryTag);
            this.free = 0;
            this.size = 0;
            this.hasZero = false;
        }
    }

    @Override
    public MapRecordCursor getCursor() {
        if (this.hasZero) {
            return this.cursor.init(this.memStart, this.memLimit, this.zeroMemStart, this.size + 1);
        }
        return this.cursor.init(this.memStart, this.memLimit, 0L, this.size);
    }

    @Override
    public int getKeyCapacity() {
        return this.keyCapacity;
    }

    @Override
    public MapRecord getRecord() {
        return this.record;
    }

    @Override
    public boolean isOpen() {
        return this.memStart != 0L;
    }

    @Override
    public void merge(Map srcMap, MapValueMergeFunction mergeFunc) {
        assert (this != srcMap);
        long srcSize = srcMap.size();
        if (srcSize == 0L) {
            return;
        }
        Unordered8Map src8Map = (Unordered8Map)srcMap;
        if (src8Map.hasZero) {
            if (this.hasZero) {
                mergeFunc.merge(this.valueAt(this.zeroMemStart), src8Map.valueAt(src8Map.zeroMemStart));
            } else {
                Vect.memcpy(this.zeroMemStart, src8Map.zeroMemStart, this.entrySize);
                this.hasZero = true;
            }
            if (srcSize == 1L) {
                return;
            }
        }
        block0: for (long srcAddr = src8Map.memStart; srcAddr < src8Map.memLimit; srcAddr += this.entrySize) {
            long k;
            long key = Unsafe.getUnsafe().getLong(srcAddr);
            if (key == 0L) continue;
            long destAddr = this.getStartAddress(Hash.hashLong64(key) & this.mask);
            while ((k = Unsafe.getUnsafe().getLong(destAddr)) != 0L) {
                if (k == key) {
                    mergeFunc.merge(this.valueAt(destAddr), src8Map.valueAt(srcAddr));
                    continue block0;
                }
                destAddr = this.getNextAddress(destAddr);
            }
            Vect.memcpy(destAddr, srcAddr, this.entrySize);
            ++this.size;
            if (--this.free != 0) continue;
            this.rehash();
        }
    }

    @Override
    public void reopen(int keyCapacity, long heapSize) {
        if (this.memStart == 0L) {
            keyCapacity = (int)((double)keyCapacity / this.loadFactor);
            this.initialKeyCapacity = Math.max(Numbers.ceilPow2(keyCapacity), 16);
            this.restoreInitialCapacity();
        }
    }

    @Override
    public void reopen() {
        if (this.memStart == 0L) {
            this.restoreInitialCapacity();
        }
    }

    @Override
    public void restoreInitialCapacity() {
        if (this.memStart == 0L || this.keyCapacity != this.initialKeyCapacity) {
            this.keyCapacity = this.initialKeyCapacity;
            this.mask = this.keyCapacity - 1;
            long sizeBytes = this.entrySize * (long)this.keyCapacity;
            this.memStart = this.memStart == 0L ? Unsafe.malloc(sizeBytes, this.memoryTag) : Unsafe.realloc(this.memStart, this.memLimit - this.memStart, sizeBytes, this.memoryTag);
            this.memLimit = this.memStart + sizeBytes;
        }
        if (this.keyMemStart == 0L) {
            this.keyMemStart = Unsafe.malloc(8L, this.memoryTag);
        }
        if (this.zeroMemStart == 0L) {
            this.zeroMemStart = Unsafe.malloc(this.entrySize, this.memoryTag);
        }
        this.clear();
    }

    @Override
    public void setKeyCapacity(int newKeyCapacity) {
        long requiredCapacity = (long)((double)newKeyCapacity / this.loadFactor);
        if (requiredCapacity > 0x80000000L) {
            throw CairoException.nonCritical().put("map capacity overflow");
        }
        this.rehash(Numbers.ceilPow2((int)requiredCapacity));
    }

    @Override
    public long size() {
        return this.hasZero ? (long)(this.size + 1) : (long)this.size;
    }

    @Override
    public MapValue valueAt(long startAddress) {
        return this.valueOf(startAddress, false, this.value);
    }

    @Override
    public MapKey withKey() {
        return this.key.init();
    }

    private Unordered8MapValue asNew(long startAddress, long key, long hashCode, Unordered8MapValue value) {
        Unsafe.getUnsafe().putLong(startAddress, key);
        if (--this.free == 0) {
            long k;
            this.rehash();
            startAddress = this.getStartAddress(hashCode & this.mask);
            while ((k = Unsafe.getUnsafe().getLong(startAddress)) != key) {
                startAddress = this.getNextAddress(startAddress);
            }
        }
        ++this.size;
        return this.valueOf(startAddress, true, value);
    }

    private long getNextAddress(long entryAddress) {
        if ((entryAddress += this.entrySize) < this.memLimit) {
            return entryAddress;
        }
        return this.memStart;
    }

    private long getStartAddress(long memStart, long index) {
        return memStart + this.entrySize * index;
    }

    private long getStartAddress(long index) {
        return this.memStart + this.entrySize * index;
    }

    private Unordered8MapValue probe0(long key, long startAddress, long hashCode, Unordered8MapValue value) {
        long k;
        do {
            startAddress = this.getNextAddress(startAddress);
            k = Unsafe.getUnsafe().getLong(startAddress);
            if (k != 0L) continue;
            return this.asNew(startAddress, key, hashCode, value);
        } while (k != key);
        return this.valueOf(startAddress, false, value);
    }

    private Unordered8MapValue probeReadOnly(long key, long startAddress, Unordered8MapValue value) {
        long k;
        do {
            startAddress = this.getNextAddress(startAddress);
            k = Unsafe.getUnsafe().getLong(startAddress);
            if (k != 0L) continue;
            return null;
        } while (k != key);
        return this.valueOf(startAddress, false, value);
    }

    private void rehash() {
        this.rehash((long)this.keyCapacity << 1);
    }

    private void rehash(long newKeyCapacity) {
        if (this.nResizes == this.maxResizes) {
            throw LimitOverflowException.instance().put("limit of ").put(this.maxResizes).put(" resizes exceeded in unordered map");
        }
        if (newKeyCapacity > 0x80000000L) {
            throw CairoException.nonCritical().put("map capacity overflow");
        }
        if (newKeyCapacity <= (long)this.keyCapacity) {
            return;
        }
        long newSizeBytes = this.entrySize * newKeyCapacity;
        long newMemStart = Unsafe.malloc(newSizeBytes, this.memoryTag);
        long newMemLimit = newMemStart + newSizeBytes;
        Vect.memset(newMemStart, newSizeBytes, 0);
        int newMask = (int)newKeyCapacity - 1;
        for (long addr = this.memStart; addr < this.memLimit; addr += this.entrySize) {
            long key = Unsafe.getUnsafe().getLong(addr);
            if (key == 0L) continue;
            long newAddr = this.getStartAddress(newMemStart, Hash.hashLong64(key) & (long)newMask);
            while (Unsafe.getUnsafe().getLong(newAddr) != 0L) {
                if ((newAddr += this.entrySize) < newMemLimit) continue;
                newAddr = newMemStart;
            }
            Vect.memcpy(newAddr, addr, this.entrySize);
        }
        Unsafe.free(this.memStart, this.memLimit - this.memStart, this.memoryTag);
        this.memStart = newMemStart;
        this.memLimit = newMemStart + newSizeBytes;
        this.mask = newMask;
        this.free += (int)((double)(newKeyCapacity - (long)this.keyCapacity) * this.loadFactor);
        this.keyCapacity = (int)newKeyCapacity;
        ++this.nResizes;
    }

    private Unordered8MapValue valueOf(long startAddress, boolean newValue, Unordered8MapValue value) {
        return value.of(startAddress, this.memLimit, newValue);
    }

    long entrySize() {
        return this.entrySize;
    }

    boolean isZeroKey(long startAddress) {
        return Unsafe.getUnsafe().getLong(startAddress) == 0L;
    }

    class Key
    implements MapKey {
        protected long appendAddress;

        Key() {
        }

        @Override
        public long commit() {
            assert (this.appendAddress <= Unordered8Map.this.keyMemStart + 8L);
            return 8L;
        }

        @Override
        public void copyFrom(MapKey srcKey) {
            Key src8Key = (Key)srcKey;
            this.copyFromRawKey(src8Key.startAddress());
        }

        @Override
        public MapValue createValue() {
            long key = Unsafe.getUnsafe().getLong(Unordered8Map.this.keyMemStart);
            if (key == 0L) {
                return this.createZeroKeyValue();
            }
            return this.createNonZeroKeyValue(key, Hash.hashLong64(key));
        }

        @Override
        public MapValue createValue(long hashCode) {
            long key = Unsafe.getUnsafe().getLong(Unordered8Map.this.keyMemStart);
            if (key == 0L) {
                return this.createZeroKeyValue();
            }
            return this.createNonZeroKeyValue(key, hashCode);
        }

        @Override
        public MapValue findValue() {
            return this.findValue(Unordered8Map.this.value);
        }

        @Override
        public MapValue findValue2() {
            return this.findValue(Unordered8Map.this.value2);
        }

        @Override
        public MapValue findValue3() {
            return this.findValue(Unordered8Map.this.value3);
        }

        @Override
        public long hash() {
            return Hash.hashLong64(Unsafe.getUnsafe().getLong(Unordered8Map.this.keyMemStart));
        }

        public Key init() {
            this.appendAddress = Unordered8Map.this.keyMemStart;
            return this;
        }

        @Override
        public void put(Record record, RecordSink sink) {
            sink.copy(record, this);
        }

        @Override
        public void putArray(ArrayView view) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putBin(BinarySequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putBool(boolean value) {
            Unsafe.getUnsafe().putByte(this.appendAddress, (byte)(value ? 1 : 0));
            ++this.appendAddress;
        }

        @Override
        public void putByte(byte value) {
            Unsafe.getUnsafe().putByte(this.appendAddress, value);
            ++this.appendAddress;
        }

        @Override
        public void putChar(char value) {
            Unsafe.getUnsafe().putChar(this.appendAddress, value);
            this.appendAddress += 2L;
        }

        @Override
        public void putDate(long value) {
            this.putLong(value);
        }

        @Override
        public void putDouble(double value) {
            Unsafe.getUnsafe().putDouble(this.appendAddress, value);
            this.appendAddress += 8L;
        }

        @Override
        public void putFloat(float value) {
            Unsafe.getUnsafe().putFloat(this.appendAddress, value);
            this.appendAddress += 4L;
        }

        @Override
        public void putIPv4(int value) {
            this.putInt(value);
        }

        @Override
        public void putInt(int value) {
            Unsafe.getUnsafe().putInt(this.appendAddress, value);
            this.appendAddress += 4L;
        }

        @Override
        public void putInterval(Interval interval) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong(long value) {
            Unsafe.getUnsafe().putLong(this.appendAddress, value);
            this.appendAddress += 8L;
        }

        @Override
        public void putLong128(long lo, long hi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong256(Long256 value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putLong256(long l0, long l1, long l2, long l3) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putRecord(Record value) {
        }

        @Override
        public void putShort(short value) {
            Unsafe.getUnsafe().putShort(this.appendAddress, value);
            this.appendAddress += 2L;
        }

        @Override
        public void putStr(CharSequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putStr(CharSequence value, int lo, int hi) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putTimestamp(long value) {
            this.putLong(value);
        }

        @Override
        public void putVarchar(Utf8Sequence value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void skip(int bytes) {
            this.appendAddress += (long)bytes;
        }

        private MapValue createNonZeroKeyValue(long key, long hashCode) {
            long startAddress = Unordered8Map.this.getStartAddress(hashCode & Unordered8Map.this.mask);
            long k = Unsafe.getUnsafe().getLong(startAddress);
            if (k == 0L) {
                return Unordered8Map.this.asNew(startAddress, key, hashCode, Unordered8Map.this.value);
            }
            if (k == key) {
                return Unordered8Map.this.valueOf(startAddress, false, Unordered8Map.this.value);
            }
            return Unordered8Map.this.probe0(key, startAddress, hashCode, Unordered8Map.this.value);
        }

        private MapValue createZeroKeyValue() {
            if (Unordered8Map.this.hasZero) {
                return Unordered8Map.this.valueOf(Unordered8Map.this.zeroMemStart, false, Unordered8Map.this.value);
            }
            Unordered8Map.this.hasZero = true;
            return Unordered8Map.this.valueOf(Unordered8Map.this.zeroMemStart, true, Unordered8Map.this.value);
        }

        private MapValue findValue(Unordered8MapValue value) {
            long key = Unsafe.getUnsafe().getLong(Unordered8Map.this.keyMemStart);
            if (key == 0L) {
                return Unordered8Map.this.hasZero ? Unordered8Map.this.valueOf(Unordered8Map.this.zeroMemStart, false, value) : null;
            }
            long startAddress = Unordered8Map.this.getStartAddress(Hash.hashLong64(key) & Unordered8Map.this.mask);
            long k = Unsafe.getUnsafe().getLong(startAddress);
            if (k == 0L) {
                return null;
            }
            if (k == key) {
                return Unordered8Map.this.valueOf(startAddress, false, value);
            }
            return Unordered8Map.this.probeReadOnly(key, startAddress, value);
        }

        void copyFromRawKey(long srcPtr) {
            long srcKey = Unsafe.getUnsafe().getLong(srcPtr);
            Unsafe.getUnsafe().putLong(this.appendAddress, srcKey);
            this.appendAddress += 8L;
        }

        long startAddress() {
            return Unordered8Map.this.keyMemStart;
        }
    }
}

