/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.pool;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoError;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.DefaultLifecycleManager;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.LifecycleManager;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.pool.AbstractPool;
import io.questdb.cairo.pool.PoolConstants;
import io.questdb.cairo.pool.ex.EntryLockedException;
import io.questdb.cairo.pool.ex.PoolClosedException;
import io.questdb.cairo.sql.AsyncWriterCommand;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WriterPool
extends AbstractPool {
    public static final String OWNERSHIP_REASON_MISSING = "missing or owned by other process";
    public static final String OWNERSHIP_REASON_NONE = null;
    public static final String OWNERSHIP_REASON_RELEASED = "released";
    public static final String OWNERSHIP_REASON_UNKNOWN = "unknown";
    static final String OWNERSHIP_REASON_WRITER_ERROR = "writer error";
    private static final long ENTRY_OWNER = Unsafe.getFieldOffset(Entry.class, "owner");
    private static final Log LOG = LogFactory.getLog(WriterPool.class);
    private static final long QUEUE_PROCESSING_OWNER = -2L;
    private final MicrosecondClock clock;
    private final CairoConfiguration configuration;
    @NotNull
    private final CairoEngine engine;
    private final ConcurrentHashMap<Entry> entries = new ConcurrentHashMap();
    private final CharSequence root;

    public WriterPool(CairoConfiguration configuration, @NotNull CairoEngine engine) {
        super(configuration, configuration.getInactiveWriterTTL());
        this.configuration = configuration;
        this.clock = configuration.getMicrosecondClock();
        this.root = configuration.getDbRoot();
        this.engine = engine;
        this.notifyListener(Thread.currentThread().getId(), null, (short)23);
    }

    public int countFreeWriters() {
        int count = 0;
        for (Entry e : this.entries.values()) {
            long owner = e.owner;
            if (owner == -1L) {
                ++count;
                continue;
            }
            LOG.info().$("table is still busy [table=").$(e.writer.getTableToken()).$(", owner=").$(owner).I$();
        }
        return count;
    }

    public Map<CharSequence, Entry> entries() {
        return this.entries;
    }

    public TableWriter get(TableToken tableToken, @NotNull String lockReason) {
        TableWriter w = this.getWriterEntry(tableToken, lockReason, null);
        assert (w != null);
        w.goActive();
        return w;
    }

    public int getBusyCount() {
        int count = 0;
        for (Entry e : this.entries.values()) {
            if (e.owner == -1L) continue;
            ++count;
        }
        return count;
    }

    public TableWriter getWriterOrPublishCommand(TableToken tableToken, @NotNull String lockReason, @NotNull AsyncWriterCommand asyncWriterCommand) {
        while (true) {
            try {
                return this.getWriterEntry(tableToken, lockReason, asyncWriterCommand);
            }
            catch (EntryUnavailableException entryUnavailableException) {
                continue;
            }
            break;
        }
    }

    public String lock(TableToken tableToken, String lockReason) {
        long owner;
        Entry e;
        this.checkClosed();
        long thread = Thread.currentThread().getId();
        while (true) {
            if ((e = this.entries.get(tableToken.getDirName())) == null) {
                e = new Entry(this.clock.getTicks());
                Entry other = this.entries.putIfAbsent(tableToken.getDirName(), e);
                if (other == null) {
                    if (this.lockAndNotify(thread, e, tableToken, lockReason)) {
                        return OWNERSHIP_REASON_NONE;
                    }
                    this.entries.remove(tableToken.getDirName());
                    return this.reinterpretOwnershipReason(e.ownershipReason);
                }
                e = other;
            }
            if (Unsafe.cas((Object)e, ENTRY_OWNER, -1L, thread)) {
                this.closeWriter(thread, e, (short)19, 2);
                if (this.lockAndNotify(thread, e, tableToken, lockReason)) {
                    return OWNERSHIP_REASON_NONE;
                }
                return this.reinterpretOwnershipReason(e.ownershipReason);
            }
            owner = e.owner;
            if (owner >= 0L) break;
            Os.pause();
        }
        LOG.error().$("could not lock, busy [table=").$(tableToken).$(", owner=").$(owner).$(", thread=").$(thread).I$();
        this.notifyListener(thread, tableToken, (short)7);
        return this.reinterpretOwnershipReason(e.ownershipReason);
    }

    public int size() {
        return this.entries.size();
    }

    public void unlock(TableToken tableToken, @Nullable TableWriter writer, boolean newTable) {
        long thread = Thread.currentThread().getId();
        Entry e = this.entries.get(tableToken.getDirName());
        if (e == null) {
            this.notifyListener(thread, tableToken, (short)9);
            return;
        }
        if (e.owner == thread) {
            if (e.writer != null) {
                this.notifyListener(thread, tableToken, (short)9);
                throw CairoException.critical(0).put("Writer ").put(tableToken.getDirName()).put(" is not locked");
            }
            assert (!newTable || writer == null && e.lockFd != -1L);
            if (writer == null) {
                Path path;
                if (e.lockFd != -1L && !this.ff.closeRemove(e.lockFd, TableUtils.lockName(path = Path.getThreadLocal(this.root).concat(tableToken.getDirName())))) {
                    LOG.error().$("could not remove [file=").$(path).$(']').$();
                }
                this.entries.remove(tableToken.getDirName());
            } else {
                e.writer = writer;
                writer.setLifecycleManager(e);
                writer.transferLock(e.lockFd);
                e.lockFd = -1L;
                e.ownershipReason = OWNERSHIP_REASON_NONE;
                Unsafe.getUnsafe().storeFence();
                Unsafe.getUnsafe().putOrderedLong(e, ENTRY_OWNER, -1L);
            }
        } else {
            this.notifyListener(thread, tableToken, (short)12);
            throw CairoException.critical(0).put("Not lock owner of ").put(tableToken.getDirNameUtf8());
        }
        this.notifyListener(thread, tableToken, (short)8);
        LOG.debug().$("unlocked [table=").$(tableToken).$(", thread=").$(thread).I$();
    }

    public void unlock(TableToken tableToken) {
        this.unlock(tableToken, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCommandToWriterQueue(Entry e, AsyncWriterCommand asyncWriterCommand, long thread) {
        TableWriter writer;
        while ((writer = e.writer) == null && e.owner != -1L) {
            Os.pause();
        }
        if (writer == null) {
            throw EntryUnavailableException.instance("please retry");
        }
        asyncWriterCommand.startAsync();
        writer.publishAsyncWriterCommand(asyncWriterCommand);
        while (e.owner == -2L) {
            Os.pause();
        }
        if (Unsafe.cas((Object)e, ENTRY_OWNER, -1L, thread)) {
            try {
                writer.tick(true);
            }
            finally {
                Unsafe.cas((Object)e, ENTRY_OWNER, thread, -1L);
            }
        }
    }

    private void assertLockReasonIsNone(String lockReason) {
        if (lockReason == OWNERSHIP_REASON_NONE) {
            throw new NullPointerException();
        }
    }

    private void checkClosed() {
        if (this.isClosed()) {
            LOG.info().$("is closed").$();
            throw PoolClosedException.INSTANCE;
        }
    }

    private TableWriter checkClosedAndGetWriter(TableToken tableToken, Entry e, String lockReason) {
        this.assertLockReasonIsNone(lockReason);
        if (this.isClosed()) {
            LOG.info().$("born free [table=").$(tableToken).I$();
            return e.goodbye();
        }
        e.ownershipReason = lockReason;
        e.writer.updateTableToken(tableToken);
        return this.logAndReturn(e, (short)11);
    }

    private void closeWriter(long thread, Entry e, short ev, int reason) {
        TableWriter w = e.writer;
        if (w != null) {
            TableToken tableToken = e.writer.getTableToken();
            w.setLifecycleManager(DefaultLifecycleManager.INSTANCE);
            w.close();
            e.writer = null;
            e.ownershipReason = OWNERSHIP_REASON_RELEASED;
            LOG.info().$("closed [table=").$(tableToken).$(", reason=").$(PoolConstants.closeReasonText(reason)).$(", by=").$(thread).I$();
            this.notifyListener(thread, tableToken, ev);
        }
    }

    private TableWriter createWriter(TableToken tableToken, Entry e, long thread, String lockReason) {
        try {
            this.checkClosed();
            LOG.info().$("open [table=").$(tableToken).$(", thread=").$(thread).I$();
            e.writer = new TableWriter(this.configuration, tableToken, this.engine.getMessageBus(), null, true, e, this.root, this.engine.getDdlListener(tableToken), this.engine.getCheckpointStatus(), this.engine);
            e.ownershipReason = lockReason;
            return this.logAndReturn(e, (short)10);
        }
        catch (CairoException ex) {
            LogRecord record = ex.isCritical() ? LOG.critical() : LOG.error();
            record.$("could not open [table=").$(tableToken).$(", thread=").$(e.owner).$(", msg=").$safe(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).I$();
            e.ex = ex;
            e.ownershipReason = OWNERSHIP_REASON_WRITER_ERROR;
            e.owner = -1L;
            this.notifyListener(e.owner, tableToken, (short)14);
            throw ex;
        }
        catch (CairoError ex) {
            LOG.critical().$("could not open [table=").$(tableToken).$(", thread=").$(e.owner).$(", ex=").$safe(ex.getFlyweightMessage()).I$();
            e.ownershipReason = OWNERSHIP_REASON_WRITER_ERROR;
            e.owner = -1L;
            this.notifyListener(e.owner, tableToken, (short)14);
            throw ex;
        }
    }

    private TableWriter getWriterEntry(TableToken tableToken, @NotNull String lockReason, @Nullable AsyncWriterCommand asyncWriterCommand) {
        long owner;
        Entry e;
        this.checkClosed();
        long thread = Thread.currentThread().getId();
        while (true) {
            if ((e = this.entries.get(tableToken.getDirName())) == null) {
                e = new Entry(this.clock.getTicks());
                Entry other = this.entries.putIfAbsent(tableToken.getDirName(), e);
                if (other == null) {
                    return this.createWriter(tableToken, e, thread, lockReason);
                }
                e = other;
            }
            if (Unsafe.cas((Object)e, ENTRY_OWNER, -1L, thread)) {
                if (e.writer == null) {
                    return this.createWriter(tableToken, e, thread, lockReason);
                }
                return this.checkClosedAndGetWriter(tableToken, e, lockReason);
            }
            owner = e.owner;
            if (owner >= 0L) break;
            Os.pause();
        }
        if (owner == thread) {
            if (e.lockFd != -1L) {
                throw EntryLockedException.instance(this.reinterpretOwnershipReason(e.ownershipReason));
            }
            if (e.ex != null) {
                this.notifyListener(thread, tableToken, (short)21);
                this.entries.remove(tableToken.getDirName());
                throw e.ex;
            }
        }
        if (asyncWriterCommand != null) {
            this.addCommandToWriterQueue(e, asyncWriterCommand, thread);
            return null;
        }
        String reason = this.reinterpretOwnershipReason(e.ownershipReason);
        if (!tableToken.isWal()) {
            LOG.info().$("busy [table=").$(tableToken).$(", owner=").$(owner).$(", thread=").$(thread).$(", reason=").$(reason).I$();
        }
        throw EntryUnavailableException.instance(reason);
    }

    private boolean lockAndNotify(long thread, Entry e, TableToken tableToken, String lockReason) {
        this.assertLockReasonIsNone(lockReason);
        Path path = Path.getThreadLocal(this.root).concat(tableToken.getDirName());
        e.lockFd = TableUtils.lock(this.ff, TableUtils.lockName(path));
        if (e.lockFd == -1L) {
            LOG.error().$("could not lock [table=").$(tableToken).$(", thread=").$(thread).I$();
            e.ownershipReason = OWNERSHIP_REASON_MISSING;
            e.owner = -1L;
            return false;
        }
        LOG.debug().$("locked [table=").$(tableToken).$(", thread=").$(thread).I$();
        this.notifyListener(thread, tableToken, (short)6);
        e.ownershipReason = lockReason;
        return true;
    }

    private TableWriter logAndReturn(Entry e, short event) {
        LOG.debug().$(">> [table=").$(e.writer.getTableToken()).$(", thread=").$(e.owner).I$();
        this.notifyListener(e.owner, e.writer.getTableToken(), event);
        return e.writer;
    }

    private String reinterpretOwnershipReason(String providedReason) {
        return providedReason == OWNERSHIP_REASON_NONE ? OWNERSHIP_REASON_UNKNOWN : providedReason;
    }

    private boolean returnToPool(Entry e) {
        boolean isDistressed;
        long thread = Thread.currentThread().getId();
        TableToken tableToken = e.writer.getTableToken();
        try {
            e.writer.rollback();
            isDistressed = e.writer.isDistressed();
            if (!isDistressed) {
                if (e.owner != -1L) {
                    e.owner = -2L;
                }
                e.writer.tick(true);
                e.writer.goPassive();
            }
        }
        catch (Throwable ex) {
            isDistressed = true;
        }
        if (isDistressed) {
            this.entries.remove(tableToken.getDirName());
            this.closeWriter(thread, e, (short)19, 5);
            this.notifyListener(thread, tableToken, (short)1);
            return true;
        }
        if (e.owner != -1L) {
            LOG.debug().$("<< [table=`").$(tableToken).$("`, thread=").$(thread).$(']').$();
            e.ownershipReason = OWNERSHIP_REASON_NONE;
            e.lastReleaseTime = this.configuration.getMicrosecondClock().getTicks();
            Unsafe.getUnsafe().storeFence();
            Unsafe.getUnsafe().putOrderedLong(e, ENTRY_OWNER, -1L);
            if (this.isClosed() && Unsafe.cas((Object)e, ENTRY_OWNER, -1L, thread)) {
                e.writer = null;
                this.notifyListener(thread, tableToken, (short)2);
                return false;
            }
            this.notifyListener(thread, tableToken, (short)1);
        } else {
            LOG.critical().$("orphaned [table=").$(tableToken).I$();
            this.notifyListener(thread, tableToken, (short)3);
        }
        return true;
    }

    @Override
    protected void closePool() {
        super.closePool();
        LOG.info().$("closed").$();
    }

    @Override
    protected boolean releaseAll(long deadline) {
        long thread = Thread.currentThread().getId();
        boolean removed = false;
        int reason = deadline == Long.MAX_VALUE ? 1 : 3;
        Iterator<Entry> iterator = this.entries.values().iterator();
        while (iterator.hasNext()) {
            Entry e = iterator.next();
            if (deadline > e.lastReleaseTime && e.owner == -1L) {
                if (!Unsafe.cas((Object)e, ENTRY_OWNER, -1L, -thread - 3L)) continue;
                this.closeWriter(thread, e, (short)17, reason);
                iterator.remove();
                removed = true;
                continue;
            }
            if (e.lockFd != -1L && deadline == Long.MAX_VALUE) {
                if (!this.ff.close(e.lockFd)) continue;
                e.lockFd = -1L;
                iterator.remove();
                removed = true;
                continue;
            }
            if (e.ex == null) continue;
            LOG.info().$("purging entry for failed to allocate writer").$();
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    public class Entry
    implements LifecycleManager {
        private CairoException ex = null;
        private volatile long lastReleaseTime;
        private volatile long lockFd = -1L;
        private volatile long owner = Thread.currentThread().getId();
        private volatile String ownershipReason = OWNERSHIP_REASON_NONE;
        private TableWriter writer;

        public Entry(long lastReleaseTime) {
            this.lastReleaseTime = lastReleaseTime;
        }

        @Override
        public boolean close() {
            return !WriterPool.this.returnToPool(this);
        }

        public long getLastReleaseTime() {
            return this.lastReleaseTime;
        }

        public long getOwnerThread() {
            return this.owner;
        }

        public String getOwnershipReason() {
            return this.ownershipReason;
        }

        public TableToken getTableToken() {
            return this.writer != null ? this.writer.getTableToken() : null;
        }

        public TableWriter goodbye() {
            TableWriter w = this.writer;
            if (this.writer != null) {
                this.writer.setLifecycleManager(DefaultLifecycleManager.INSTANCE);
                this.writer = null;
            }
            return w;
        }
    }
}

