/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.http;

import io.questdb.ClientTlsConfiguration;
import io.questdb.HttpClientConfiguration;
import io.questdb.client.Sender;
import io.questdb.cutlass.http.client.HttpClient;
import io.questdb.cutlass.line.array.ArrayDataAppender;
import io.questdb.cutlass.line.array.ArrayShapeAppender;
import io.questdb.cutlass.line.array.DoubleArray;
import io.questdb.cutlass.line.array.FlattenArrayUtils;
import io.questdb.cutlass.line.array.LongArray;
import io.questdb.cutlass.line.http.AbstractLineHttpSender;
import org.jetbrains.annotations.NotNull;

public class LineHttpSenderV2
extends AbstractLineHttpSender {
    public LineHttpSenderV2(String host, int port, HttpClientConfiguration clientConfiguration, ClientTlsConfiguration tlsConfig, int autoFlushRows, String authToken, String username, String password, int maxNameLength, long maxRetriesNanos, long minRequestThroughput, long flushIntervalNanos) {
        super(host, port, clientConfiguration, tlsConfig, autoFlushRows, authToken, username, password, maxNameLength, maxRetriesNanos, minRequestThroughput, flushIntervalNanos);
    }

    protected LineHttpSenderV2(String host, int port, String path, HttpClientConfiguration clientConfiguration, ClientTlsConfiguration tlsConfig, HttpClient client, int autoFlushRows, String authToken, String username, String password, int maxNameLength, long maxRetriesNanos, long minRequestThroughput, long flushIntervalNanos) {
        super(host, port, path, clientConfiguration, tlsConfig, client, autoFlushRows, authToken, username, password, maxNameLength, maxRetriesNanos, minRequestThroughput, flushIntervalNanos);
    }

    @Override
    public Sender doubleArray(@NotNull CharSequence name, double[] values) {
        return this.arrayColumn(name, (short)10, (byte)1, values, FlattenArrayUtils::putShapeToBuf, FlattenArrayUtils::putDataToBuf);
    }

    @Override
    public Sender doubleArray(@NotNull CharSequence name, double[][] values) {
        return this.arrayColumn(name, (short)10, (byte)2, values, FlattenArrayUtils::putShapeToBuf, FlattenArrayUtils::putDataToBuf);
    }

    @Override
    public Sender doubleArray(@NotNull CharSequence name, double[][][] values) {
        return this.arrayColumn(name, (short)10, (byte)3, values, FlattenArrayUtils::putShapeToBuf, FlattenArrayUtils::putDataToBuf);
    }

    @Override
    public Sender doubleArray(CharSequence name, DoubleArray array) {
        if (this.processNullArray(name, array)) {
            return this;
        }
        this.writeFieldName(name).putAscii('=').put((byte)14).put((byte)10);
        array.appendToBufPtr(this.request);
        return this;
    }

    @Override
    public Sender doubleColumn(CharSequence name, double value) {
        this.writeFieldName(name).putAscii('=').put((byte)16).putDouble(value);
        return this;
    }

    @Override
    public Sender longArray(@NotNull CharSequence name, long[] values) {
        return this.arrayColumn(name, (short)6, (byte)1, values, FlattenArrayUtils::putShapeToBuf, FlattenArrayUtils::putDataToBuf);
    }

    @Override
    public Sender longArray(@NotNull CharSequence name, long[][] values) {
        return this.arrayColumn(name, (short)6, (byte)2, values, FlattenArrayUtils::putShapeToBuf, FlattenArrayUtils::putDataToBuf);
    }

    @Override
    public Sender longArray(@NotNull CharSequence name, long[][][] values) {
        return this.arrayColumn(name, (short)6, (byte)3, values, FlattenArrayUtils::putShapeToBuf, FlattenArrayUtils::putDataToBuf);
    }

    @Override
    public Sender longArray(@NotNull CharSequence name, LongArray values) {
        if (this.processNullArray(name, values)) {
            return this;
        }
        this.writeFieldName(name).putAscii('=').put((byte)14).put((byte)6);
        values.appendToBufPtr(this.request);
        return this;
    }

    private <T> Sender arrayColumn(CharSequence name, short columnType, byte nDims, T array, ArrayShapeAppender<T> shapeAppender, ArrayDataAppender<T> dataAppender) {
        if (this.processNullArray(name, array)) {
            return this;
        }
        this.writeFieldName(name).putAscii('=').put((byte)14).put((byte)columnType).put(nDims);
        shapeAppender.append(this.request, array);
        dataAppender.append(this.request, array);
        return this;
    }

    private boolean processNullArray(CharSequence name, Object value) {
        if (value == null) {
            this.writeFieldName(name).putAscii('=').put((byte)14).put((byte)33);
            return true;
        }
        return false;
    }
}

