/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.line.tcp;

import io.questdb.cutlass.line.LineChannel;
import io.questdb.cutlass.line.LineSenderException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.NetworkFacade;

public final class PlainTcpLineChannel
implements LineChannel {
    private static final Log LOG = LogFactory.getLog(PlainTcpLineChannel.class);
    private final long fd;
    private final NetworkFacade nf;
    private final long sockaddr;

    public PlainTcpLineChannel(NetworkFacade nf, int address, int port, int sndBufferSize) {
        this.nf = nf;
        this.fd = nf.socketTcp(true);
        if (this.fd < 0L) {
            throw new LineSenderException((CharSequence)"could not allocate a file descriptor").errno(nf.errno());
        }
        nf.configureKeepAlive(this.fd);
        this.sockaddr = nf.sockaddr(address, port);
        if (nf.connect(this.fd, this.sockaddr) != 0) {
            int errno = nf.errno();
            nf.close(this.fd, LOG);
            nf.freeSockAddr(this.sockaddr);
            throw new LineSenderException((CharSequence)"could not connect to host ").put("[ip=").appendIPv4(address).put("]").errno(errno);
        }
        this.configureBuffers(nf, sndBufferSize);
    }

    public PlainTcpLineChannel(NetworkFacade nf, CharSequence host, int port, int sndBufferSize) {
        this.nf = nf;
        this.sockaddr = -1L;
        this.fd = nf.socketTcp(true);
        if (this.fd < 0L) {
            throw new LineSenderException((CharSequence)"could not allocate a file descriptor").errno(nf.errno());
        }
        nf.configureKeepAlive(this.fd);
        long addrInfo = nf.getAddrInfo(host, port);
        if (addrInfo == -1L) {
            nf.close(this.fd, LOG);
            throw new LineSenderException((CharSequence)"could not resolve host ").put("[host=").put(host).put("]");
        }
        if (nf.connectAddrInfo(this.fd, addrInfo) != 0) {
            int errno = nf.errno();
            nf.close(this.fd, LOG);
            nf.freeAddrInfo(addrInfo);
            throw new LineSenderException((CharSequence)"could not connect to host ").put("[host=").put(host).put("]").errno(errno);
        }
        nf.freeAddrInfo(addrInfo);
        this.configureBuffers(nf, sndBufferSize);
    }

    @Override
    public void close() {
        this.nf.close(this.fd, LOG);
        if (this.sockaddr != -1L) {
            this.nf.freeSockAddr(this.sockaddr);
        }
    }

    @Override
    public int errno() {
        return this.nf.errno();
    }

    @Override
    public int receive(long ptr, int len) {
        return this.nf.recvRaw(this.fd, ptr, len);
    }

    @Override
    public void send(long ptr, int len) {
        if (len > 0) {
            long o = 0L;
            while (len > 0) {
                int n = this.nf.sendRaw(this.fd, ptr + o, len);
                if (n > 0) {
                    len -= n;
                    o += (long)n;
                    continue;
                }
                throw new LineSenderException((CharSequence)"send error ").errno(this.nf.errno());
            }
        }
    }

    private void configureBuffers(NetworkFacade nf, int sndBufferSize) {
        int orgSndBufSz = nf.getSndBuf(this.fd);
        nf.setSndBuf(this.fd, sndBufferSize);
        int newSndBufSz = nf.getSndBuf(this.fd);
        LOG.debug().$("Send buffer size change from ").$(orgSndBufSz).$(" to ").$(newSndBufSz).$();
    }
}

