/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.text;

import io.questdb.std.FlyweightMessageContainer;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import io.questdb.std.str.Utf8Sequence;
import org.jetbrains.annotations.NotNull;

public class TextImportException
extends RuntimeException
implements Sinkable,
FlyweightMessageContainer {
    private static final ThreadLocal<TextImportException> tlException = new ThreadLocal<TextImportException>(TextImportException::new);
    private final StringSink message = new StringSink();
    private boolean cancelled;
    private byte phase;

    public static TextImportException instance(byte phase, CharSequence message) {
        return TextImportException.instance(phase, message, Integer.MIN_VALUE);
    }

    public static TextImportException instance(byte phase, CharSequence message, int errno) {
        TextImportException te = tlException.get();
        te.phase = phase;
        te.cancelled = false;
        StringSink sink = te.message;
        sink.clear();
        if (errno > Integer.MIN_VALUE) {
            ((Utf16Sink)sink.put('[').put(errno)).put("] ");
        }
        sink.put(message);
        return te;
    }

    @Override
    public CharSequence getFlyweightMessage() {
        return this.message;
    }

    @Override
    public String getMessage() {
        return this.message.toString();
    }

    public byte getPhase() {
        return this.phase;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public TextImportException put(CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    public TextImportException put(Utf8Sequence us) {
        this.message.put(us);
        return this;
    }

    public TextImportException put(char c) {
        this.message.put(c);
        return this;
    }

    public TextImportException put(double c) {
        this.message.put(c);
        return this;
    }

    public TextImportException put(long c) {
        this.message.put(c);
        return this;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.put(this.message);
    }
}

