/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.griffin.PurgingOperator;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.str.Path;

public class DropIndexOperator {
    private static final Log LOG = LogFactory.getLog(DropIndexOperator.class);
    private final FilesFacade ff;
    private final Path other;
    private final Path path;
    private final PurgingOperator purgingOperator;
    private final LongList rollbackColumnVersions = new LongList();
    private final int rootLen;
    private final TableWriter tableWriter;

    public DropIndexOperator(CairoConfiguration configuration, TableWriter tableWriter, Path path, Path other, int rootLen, PurgingOperator purgingOperator) {
        this.other = other;
        this.tableWriter = tableWriter;
        this.rootLen = rootLen;
        this.purgingOperator = purgingOperator;
        this.path = path;
        this.ff = configuration.getFilesFacade();
    }

    public void executeDropIndex(String columnName, int columnIndex) {
        int partitionBy = this.tableWriter.getPartitionBy();
        int partitionCount = this.tableWriter.getPartitionCount();
        try {
            this.purgingOperator.clear();
            this.rollbackColumnVersions.clear();
            for (int pIndex = 0; pIndex < partitionCount; ++pIndex) {
                long pTimestamp = this.tableWriter.getPartitionTimestamp(pIndex);
                long pVersion = this.tableWriter.getPartitionNameTxn(pIndex);
                long columnVersion = this.tableWriter.getColumnNameTxn(pTimestamp, columnIndex);
                long columnTop = this.tableWriter.getColumnTop(pTimestamp, columnIndex, -1L);
                byte partitionFormat = this.tableWriter.getPartitionFormat(pIndex);
                if (columnTop == -1L) continue;
                this.tableWriter.upsertColumnVersion(pTimestamp, columnIndex, columnTop);
                if (partitionFormat == 0) {
                    long columnDropIndexVersion = this.tableWriter.getColumnNameTxn(pTimestamp, columnIndex);
                    DropIndexOperator.partitionDFile(this.path, this.rootLen, partitionBy, pTimestamp, pVersion, columnName, columnVersion);
                    DropIndexOperator.partitionDFile(this.other, this.rootLen, partitionBy, pTimestamp, pVersion, columnName, columnDropIndexVersion);
                    if (this.ff.hardLink(this.path.$(), this.other.$()) == -1) {
                        throw CairoException.critical(this.ff.errno()).put("cannot hardLink [src=").put(this.path).put(", hardLink=").put(this.other).put(']');
                    }
                    this.rollbackColumnVersions.add(columnIndex, columnDropIndexVersion, pTimestamp, pVersion);
                }
                this.purgingOperator.add(columnIndex, columnName, 12, true, columnVersion, pTimestamp, pVersion);
            }
        }
        catch (Throwable th) {
            LOG.error().$("Could not DROP INDEX: ").$safe(th.getMessage()).$();
            this.purgingOperator.clear();
            int limit = this.rollbackColumnVersions.size();
            if (limit / 4 < partitionCount) {
                for (int i = 0; i < limit; i += 4) {
                    long columnDropIndexVersion = this.rollbackColumnVersions.getQuick(i + 1);
                    long pTimestamp = this.rollbackColumnVersions.getQuick(i + 2);
                    long partitionNameTxn = this.rollbackColumnVersions.getQuick(i + 3);
                    DropIndexOperator.partitionDFile(this.other, this.rootLen, partitionBy, pTimestamp, partitionNameTxn, columnName, columnDropIndexVersion);
                    if (this.ff.removeQuiet(this.other.$())) continue;
                    LOG.info().$("Please remove this file \"").$(this.other).$('\"').I$();
                }
            }
            throw th;
        }
        finally {
            this.path.trimTo(this.rootLen);
            this.other.trimTo(this.rootLen);
        }
    }

    private static void partitionDFile(Path path, int rootLen, int partitionBy, long partitionTimestamp, long partitionNameTxn, CharSequence columnName, long columnNameTxn) {
        TableUtils.setPathForNativePartition(path.trimTo(rootLen), partitionBy, partitionTimestamp, partitionNameTxn);
        TableUtils.dFile(path, columnName, columnNameTxn);
    }
}

