/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.array;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.arr.ArrayView;
import io.questdb.cairo.arr.DirectArray;
import io.questdb.cairo.arr.FlatArrayView;
import io.questdb.cairo.sql.ArrayFunction;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;

public class DoubleArrayRoundFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "round(D[]I)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        int scaleValue;
        Function arg = args.getQuick(0);
        Function scale = args.getQuick(1);
        if (scale.isConstant() && (scaleValue = scale.getInt(null)) > -1) {
            if (scaleValue + 2 < Numbers.pow10max) {
                return new DoubleArrayRoundPositiveScaleFunction(arg, scaleValue, configuration);
            }
            return new DoubleArrayRoundDegenerateScaleFunction(arg, configuration);
        }
        return new DoubleArrayRoundVarScaleFunction(arg, scale, configuration);
    }

    private static class DoubleArrayRoundPositiveScaleFunction
    extends ArrayFunction
    implements UnaryFunction {
        private final Function arrayArg;
        private final int scale;
        private final DirectArray array;
        private final String name;

        public DoubleArrayRoundPositiveScaleFunction(Function arrayArg, int scale, CairoConfiguration configuration) {
            this.name = "round";
            this.arrayArg = arrayArg;
            this.scale = scale;
            this.type = arrayArg.getType();
            this.array = new DirectArray(configuration);
        }

        @Override
        public void close() {
            UnaryFunction.super.close();
            Misc.free(this.array);
        }

        @Override
        public Function getArg() {
            return this.arrayArg;
        }

        @Override
        public ArrayView getArray(Record rec) {
            ArrayView arr = this.arrayArg.getArray(rec);
            if (arr.isNull()) {
                this.array.ofNull();
                return this.array;
            }
            MemoryA memory = this.array.copyShapeAndStartMemoryA(arr);
            if (arr.isVanilla()) {
                FlatArrayView flatView = arr.flatView();
                int n = arr.getHi();
                for (int i = arr.getLo(); i < n; ++i) {
                    memory.putDouble(DoubleArrayRoundPositiveScaleFunction.roundNc(flatView.getDoubleAtAbsIndex(i), this.scale));
                }
            } else {
                DoubleArrayRoundPositiveScaleFunction.calculateRecursive(arr, 0, 0, this.scale, memory);
            }
            return this.array;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isOperator() {
            return true;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        private static void calculateRecursive(ArrayView view, int dim, int flatIndex, int scale, MemoryA memOut) {
            boolean atDeepestDim;
            int count = view.getDimLen(dim);
            int stride = view.getStride(dim);
            boolean bl = atDeepestDim = dim == view.getDimCount() - 1;
            if (atDeepestDim) {
                for (int i = 0; i < count; ++i) {
                    memOut.putDouble(DoubleArrayRoundPositiveScaleFunction.roundNc(view.getDouble(flatIndex), scale));
                    flatIndex += stride;
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    DoubleArrayRoundPositiveScaleFunction.calculateRecursive(view, dim + 1, flatIndex, scale, memOut);
                    flatIndex += stride;
                }
            }
        }

        private static double roundNc(double d, int scale) {
            if (Numbers.isFinite(d)) {
                return Numbers.roundHalfUpPosScale(d, scale);
            }
            return Double.NaN;
        }
    }

    private static class DoubleArrayRoundDegenerateScaleFunction
    extends ArrayFunction
    implements UnaryFunction {
        private final Function arrayArg;
        private final DirectArray array;
        private final String name;

        public DoubleArrayRoundDegenerateScaleFunction(Function arrayArg, CairoConfiguration configuration) {
            this.name = "round";
            this.arrayArg = arrayArg;
            this.type = arrayArg.getType();
            this.array = new DirectArray(configuration);
        }

        @Override
        public void close() {
            UnaryFunction.super.close();
            Misc.free(this.array);
        }

        @Override
        public Function getArg() {
            return this.arrayArg;
        }

        @Override
        public ArrayView getArray(Record rec) {
            ArrayView arr = this.arrayArg.getArray(rec);
            if (arr.isNull()) {
                this.array.ofNull();
                return this.array;
            }
            MemoryA memory = this.array.copyShapeAndStartMemoryA(arr);
            int n = arr.getHi();
            for (int i = arr.getLo(); i < n; ++i) {
                memory.putDouble(Double.NaN);
            }
            return this.array;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isOperator() {
            return true;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }
    }

    private static class DoubleArrayRoundVarScaleFunction
    extends ArrayFunction
    implements BinaryFunction {
        private final DirectArray array;
        private final Function arrayArg;
        private final String name;
        private final Function scalarArg;

        public DoubleArrayRoundVarScaleFunction(Function arrayArg, Function scalarArg, CairoConfiguration configuration) {
            this.name = "round";
            this.arrayArg = arrayArg;
            this.scalarArg = scalarArg;
            this.type = arrayArg.getType();
            this.array = new DirectArray(configuration);
        }

        @Override
        public void close() {
            BinaryFunction.super.close();
            Misc.free(this.array);
        }

        @Override
        public ArrayView getArray(Record rec) {
            ArrayView arr = this.arrayArg.getArray(rec);
            if (arr.isNull()) {
                this.array.ofNull();
                return this.array;
            }
            int scalarValue = this.scalarArg.getInt(rec);
            MemoryA memory = this.array.copyShapeAndStartMemoryA(arr);
            if (arr.isVanilla()) {
                FlatArrayView flatView = arr.flatView();
                int n = arr.getHi();
                for (int i = arr.getLo(); i < n; ++i) {
                    memory.putDouble(DoubleArrayRoundVarScaleFunction.roundNc(flatView.getDoubleAtAbsIndex(i), scalarValue));
                }
            } else {
                DoubleArrayRoundVarScaleFunction.calculateRecursive(arr, 0, 0, scalarValue, memory);
            }
            return this.array;
        }

        @Override
        public Function getLeft() {
            return this.arrayArg;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Function getRight() {
            return this.scalarArg;
        }

        @Override
        public boolean isOperator() {
            return true;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        private static void calculateRecursive(ArrayView view, int dim, int flatIndex, int scalarValue, MemoryA memOut) {
            boolean atDeepestDim;
            int count = view.getDimLen(dim);
            int stride = view.getStride(dim);
            boolean bl = atDeepestDim = dim == view.getDimCount() - 1;
            if (atDeepestDim) {
                for (int i = 0; i < count; ++i) {
                    memOut.putDouble(DoubleArrayRoundVarScaleFunction.roundNc(view.getDouble(flatIndex), scalarValue));
                    flatIndex += stride;
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    DoubleArrayRoundVarScaleFunction.calculateRecursive(view, dim + 1, flatIndex, scalarValue, memOut);
                    flatIndex += stride;
                }
            }
        }

        private static double roundNc(double d, int scale) {
            if (Numbers.isNull(d) || Integer.MIN_VALUE == scale) {
                return Double.NaN;
            }
            try {
                return Numbers.roundHalfUp(d, scale);
            }
            catch (NumericException ignore) {
                return Double.NaN;
            }
        }
    }
}

