/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.GeoByteFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;

public abstract class AbstractCastToGeoHashFunction
extends GeoByteFunction
implements UnaryFunction {
    protected final Function arg;
    protected final int bitsPrecision;
    protected final int position;

    public AbstractCastToGeoHashFunction(int geoType, Function arg, int position) {
        super(geoType);
        this.arg = arg;
        this.position = position;
        this.bitsPrecision = ColumnType.getGeoHashBits(geoType);
        assert (this.bitsPrecision > 0 && this.bitsPrecision < 61);
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public byte getGeoByte(Record rec) {
        assert (this.bitsPrecision < 8);
        return (byte)this.getGeoHashLong0(rec);
    }

    @Override
    public int getGeoInt(Record rec) {
        assert (this.bitsPrecision >= 16 && this.bitsPrecision < 32);
        return (int)this.getGeoHashLong0(rec);
    }

    @Override
    public long getGeoLong(Record rec) {
        assert (this.bitsPrecision >= 32);
        return this.getGeoHashLong0(rec);
    }

    @Override
    public short getGeoShort(Record rec) {
        assert (this.bitsPrecision >= 8 && this.bitsPrecision < 16);
        return (short)this.getGeoHashLong0(rec);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val(this.arg).val("::geohash");
    }

    protected abstract long getGeoHashLong0(Record var1);
}

