/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToIntFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;

public class CastVarcharToIntFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(\u00d8i)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0));
    }

    private static class Func
    extends AbstractCastToIntFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public int getInt(Record rec) {
            Utf8Sequence value = this.arg.getVarcharA(rec);
            return Numbers.parseIntQuiet(value != null ? value.asAsciiCharSequence() : null);
        }
    }
}

