/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.cast.AbstractCastToUuidFunction;
import io.questdb.griffin.engine.functions.constants.UuidConstant;
import io.questdb.std.IntList;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Uuid;
import io.questdb.std.str.Utf8Sequence;

public class CastVarcharToUuidFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "cast(\u00d8z)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            Utf8Sequence value = arg.getVarcharA(null);
            if (value == null || value.size() == 0) {
                return UuidConstant.NULL;
            }
            Uuid uuid = new Uuid();
            try {
                uuid.of(value);
            }
            catch (NumericException e) {
                throw SqlException.$(argPositions.getQuick(0), "invalid UUID constant");
            }
            return new UuidConstant(uuid);
        }
        return new Func(arg);
    }

    public static class Func
    extends AbstractCastToUuidFunction {
        public Func(Function arg) {
            super(arg);
        }

        @Override
        public long getLong128Hi(Record rec) {
            Utf8Sequence value = this.arg.getVarcharA(rec);
            if (value == null) {
                return Long.MIN_VALUE;
            }
            try {
                Uuid.checkDashesAndLength(value.asAsciiCharSequence());
                return Uuid.parseHi(value.asAsciiCharSequence());
            }
            catch (NumericException e) {
                return Long.MIN_VALUE;
            }
        }

        @Override
        public long getLong128Lo(Record rec) {
            Utf8Sequence value = this.arg.getVarcharA(rec);
            if (value == null) {
                return Long.MIN_VALUE;
            }
            try {
                Uuid.checkDashesAndLength(value.asAsciiCharSequence());
                return Uuid.parseLo(value.asAsciiCharSequence());
            }
            catch (NumericException e) {
                return Long.MIN_VALUE;
            }
        }
    }
}

