/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class PgExtensionFunctionFactory
implements FunctionFactory {
    private static final int COLUMN_EXTVERSION = 5;
    private static final RecordMetadata METADATA;

    @Override
    public String getSignature() {
        return "pg_extension()";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new PgExtensionCursorFactory(configuration));
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("oid", 11));
        metadata.add(new TableColumnMetadata("extname", 11));
        metadata.add(new TableColumnMetadata("extowner", 11));
        metadata.add(new TableColumnMetadata("extnamespace", 11));
        metadata.add(new TableColumnMetadata("extrelocatable", 1));
        metadata.add(new TableColumnMetadata("extversion", 11));
        metadata.add(new TableColumnMetadata("extconfig", 11));
        metadata.add(new TableColumnMetadata("extcondition", 11));
        METADATA = metadata;
    }

    private static class PgExtensionCursorFactory
    extends AbstractRecordCursorFactory {
        private final PgExtensionRecordCursor cursor;

        public PgExtensionCursorFactory(CairoConfiguration configuration) {
            super(METADATA);
            this.cursor = new PgExtensionRecordCursor(configuration.getBuildInformation().getSwVersion());
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type("pg_extension()");
        }

        private static class PgExtensionRecordCursor
        implements NoRandomAccessRecordCursor {
            private static final String[][] EXTENSIONS = new String[][]{{"1", "questdb", "1", "1", "false", null, null, null}};
            private final PgExtensionRecord record = new PgExtensionRecord();
            private final CharSequence version;
            private int index = -1;

            public PgExtensionRecordCursor(CharSequence version) {
                this.version = version;
            }

            @Override
            public void close() {
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public boolean hasNext() {
                return ++this.index < EXTENSIONS.length;
            }

            @Override
            public long size() {
                return EXTENSIONS.length;
            }

            @Override
            public long preComputedStateSize() {
                return 0L;
            }

            @Override
            public void toTop() {
                this.index = -1;
            }

            public class PgExtensionRecord
            implements Record {
                @Override
                public boolean getBool(int col) {
                    return false;
                }

                @Override
                public CharSequence getStrA(int col) {
                    if (col == 5) {
                        return PgExtensionRecordCursor.this.version;
                    }
                    return EXTENSIONS[0][col];
                }

                @Override
                public CharSequence getStrB(int col) {
                    return this.getStrA(col);
                }

                @Override
                public int getStrLen(int col) {
                    return TableUtils.lengthOf(this.getStrA(col));
                }
            }
        }
    }
}

