/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.conditional;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.VarcharFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;

public class NullIfVarcharFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "nullif(\u00d8\u00d8)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new Func(args.getQuick(0), args.getQuick(1));
    }

    private static class Func
    extends VarcharFunction
    implements BinaryFunction {
        private final Function varcharFunc1;
        private final Function varcharFunc2;

        public Func(Function varcharFunc1, Function varcharFunc2) {
            this.varcharFunc1 = varcharFunc1;
            this.varcharFunc2 = varcharFunc2;
        }

        @Override
        public Function getLeft() {
            return this.varcharFunc1;
        }

        @Override
        public String getName() {
            return "nullif";
        }

        @Override
        public Function getRight() {
            return this.varcharFunc2;
        }

        @Override
        public Utf8Sequence getVarcharA(Record rec) {
            Utf8Sequence us1 = this.varcharFunc1.getVarcharA(rec);
            if (us1 == null) {
                return null;
            }
            Utf8Sequence us2 = this.varcharFunc2.getVarcharA(rec);
            if (us2 == null || !Utf8s.equals(us1, us2)) {
                return us1;
            }
            return null;
        }

        @Override
        public Utf8Sequence getVarcharB(Record rec) {
            Utf8Sequence us1 = this.varcharFunc1.getVarcharB(rec);
            if (us1 == null) {
                return null;
            }
            Utf8Sequence us2 = this.varcharFunc2.getVarcharB(rec);
            if (us2 == null || !Utf8s.equals(us1, us2)) {
                return us1;
            }
            return null;
        }
    }
}

