/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.date;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.StrFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.StrConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.millitime.DateFormatFactory;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import org.jetbrains.annotations.Nullable;

public class ToStrDateFunctionFactory
implements FunctionFactory {
    private static final ThreadLocal<StringSink> tlSink = ThreadLocal.withInitial(StringSink::new);

    @Override
    public String getSignature() {
        return "to_str(Ms)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function fmt = args.getQuick(1);
        CharSequence format = fmt.getStrA(null);
        if (format == null) {
            throw SqlException.$(argPositions.getQuick(1), "format must not be null");
        }
        DateFormat dateFormat = DateFormatFactory.INSTANCE.get(format);
        Function var = args.getQuick(0);
        if (var.isConstant()) {
            long value = var.getDate(null);
            if (value == Long.MIN_VALUE) {
                return StrConstant.NULL;
            }
            StringSink sink = tlSink.get();
            sink.clear();
            dateFormat.format(value, configuration.getDefaultDateLocale(), "Z", sink);
            return new StrConstant(sink);
        }
        return new ToCharDateVCFFunc(args.getQuick(0), DateFormatFactory.INSTANCE.get(format), configuration.getDefaultDateLocale(), format);
    }

    private static class ToCharDateVCFFunc
    extends StrFunction
    implements UnaryFunction {
        final Function arg;
        final DateFormat format;
        final CharSequence formatStr;
        final DateLocale locale;
        final StringSink sinkA;
        final StringSink sinkB;

        public ToCharDateVCFFunc(Function arg, DateFormat format, DateLocale locale, CharSequence formatStr) {
            this.arg = arg;
            this.format = format;
            this.locale = locale;
            this.sinkA = new StringSink();
            this.sinkB = new StringSink();
            this.formatStr = formatStr;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public CharSequence getStrA(Record rec) {
            return this.toSink(rec, this.sinkA);
        }

        @Override
        public CharSequence getStrB(Record rec) {
            return this.toSink(rec, this.sinkB);
        }

        @Override
        public int getStrLen(Record rec) {
            long value = this.arg.getDate(rec);
            if (value != Long.MIN_VALUE) {
                this.sinkA.clear();
                this.toSink(value, (Utf16Sink)this.sinkA);
                return this.sinkA.length();
            }
            return -1;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val("to_str(").val(this.arg).val(',').val(this.formatStr).val(')');
        }

        @Nullable
        private CharSequence toSink(Record rec, StringSink sink) {
            long value = this.arg.getDate(rec);
            if (value != Long.MIN_VALUE) {
                sink.clear();
                this.toSink(value, (Utf16Sink)sink);
                return sink;
            }
            return null;
        }

        private void toSink(long value, Utf16Sink sink) {
            this.format.format(value, this.locale, "Z", sink);
        }
    }
}

