/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.groupby.ApproxPercentileDoubleGroupByFunction;
import io.questdb.griffin.engine.functions.groupby.ApproxPercentileDoublePackedGroupByFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public class ApproxPercentileDoubleGroupByFunctionFactory
implements FunctionFactory {
    public static int checkAndReturnPrecision(@NotNull Function precisionFunc, int precisionPos) throws SqlException {
        if (!precisionFunc.isConstant()) {
            throw SqlException.$(precisionPos, "precision must be a constant");
        }
        int precision = precisionFunc.getInt(null);
        if (precision < 0 || precision > 5) {
            throw SqlException.$(precisionPos, "precision must be between 0 and 5");
        }
        return precision;
    }

    public static void checkPercentile(@NotNull Function percentileFunc, int percentilePos) throws SqlException {
        if (!percentileFunc.isConstant() && !percentileFunc.isRuntimeConstant()) {
            throw SqlException.$(percentilePos, "percentile must be a constant or runtime constant");
        }
    }

    @Override
    public String getSignature() {
        return "approx_percentile(DDi)";
    }

    @Override
    public boolean isGroupBy() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function exprFunc = args.getQuick(0);
        Function percentileFunc = args.getQuick(1);
        Function precisionFunc = args.getQuick(2);
        ApproxPercentileDoubleGroupByFunctionFactory.checkPercentile(percentileFunc, argPositions.getQuick(1));
        int precision = ApproxPercentileDoubleGroupByFunctionFactory.checkAndReturnPrecision(precisionFunc, argPositions.getQuick(2));
        if (precision > 2) {
            return new ApproxPercentileDoublePackedGroupByFunction(exprFunc, percentileFunc, precision, position);
        }
        return new ApproxPercentileDoubleGroupByFunction(exprFunc, percentileFunc, precision, position);
    }
}

