/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.lt;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class LtIPv4StrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "<(XS)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function ipv4Func = args.getQuick(0);
        int strFuncPosition = argPositions.getQuick(1);
        Function strFunc = args.getQuick(1);
        if (strFunc.isConstant()) {
            int ipv4 = strFunc.getIPv4(null);
            return new ConstStrFunc(ipv4Func, ipv4);
        }
        if (strFunc.isRuntimeConstant()) {
            return new RuntimeConstStrFunc(ipv4Func, strFunc);
        }
        throw SqlException.$(strFuncPosition, "STRING constant expected");
    }

    @Override
    public boolean supportImplicitCastCharToStr() {
        return false;
    }

    private static class ConstStrFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Function arg;
        private final int constIPv4;

        public ConstStrFunc(Function arg, int constIPv4) {
            this.arg = arg;
            this.constIPv4 = constIPv4;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public boolean getBool(Record rec) {
            return Numbers.lessThanIPv4(this.arg.getIPv4(rec), this.constIPv4, this.negated);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg);
            if (this.negated) {
                sink.val(">=");
            } else {
                sink.val('<');
            }
            sink.valIPv4(this.constIPv4);
        }
    }

    private static class RuntimeConstStrFunc
    extends NegatableBooleanFunction
    implements BinaryFunction {
        private final Function ipv4Func;
        private final Function strFunc;
        private int constIPv4;

        public RuntimeConstStrFunc(Function ipv4Func, Function strFunc) {
            this.ipv4Func = ipv4Func;
            this.strFunc = strFunc;
        }

        @Override
        public boolean getBool(Record rec) {
            return Numbers.lessThanIPv4(this.ipv4Func.getIPv4(rec), this.constIPv4, this.negated);
        }

        @Override
        public Function getLeft() {
            return this.ipv4Func;
        }

        @Override
        public Function getRight() {
            return this.strFunc;
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            BinaryFunction.super.init(symbolTableSource, executionContext);
            this.constIPv4 = this.strFunc.getIPv4(null);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.ipv4Func);
            if (this.negated) {
                sink.val(">=");
            } else {
                sink.val('<');
            }
            sink.val(this.strFunc);
        }
    }
}

