/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.lt;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.NegatableBooleanFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.griffin.engine.functions.lt.LtStrFunctionFactory;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;

public class LtVarcharStrFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "<(\u00d8S)";
    }

    @Override
    public boolean isBoolean() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        Function a = args.getQuick(0);
        Function b = args.getQuick(1);
        if (a.isConstant() && !b.isConstant()) {
            CharSequence constValue = a.getStrA(null);
            if (constValue == null) {
                return BooleanConstant.FALSE;
            }
            return new LtStrFunctionFactory.ConstOnLeftFunc(constValue, b);
        }
        if (!a.isConstant() && b.isConstant()) {
            Utf8Sequence constValue = b.getVarcharA(null);
            if (constValue == null) {
                return BooleanConstant.FALSE;
            }
            return new ConstOnRightFunc(a, constValue);
        }
        return new LtStrFunctionFactory.Func(a, b);
    }

    static class ConstOnRightFunc
    extends NegatableBooleanFunction
    implements UnaryFunction {
        private final Utf8Sequence constant;
        private final Function left;

        public ConstOnRightFunc(Function left, Utf8Sequence constant) {
            this.constant = constant;
            this.left = left;
        }

        @Override
        public Function getArg() {
            return this.left;
        }

        @Override
        public boolean getBool(Record rec) {
            return Utf8s.lessThan(this.left.getVarcharA(rec), this.constant, this.negated);
        }

        @Override
        public String getName() {
            if (this.negated) {
                return ">=";
            }
            return "<";
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.left);
            sink.val(this.getName());
            sink.val('\'').val(this.constant).val('\'');
        }
    }
}

