/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.rnd;

import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.VarcharFunction;
import io.questdb.std.Rnd;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8StringSink;

class RndVarcharFunction
extends VarcharFunction
implements Function {
    private final int lo;
    private final int nullRate;
    private final int range;
    private final Utf8StringSink utf8sinkA = new Utf8StringSink();
    private final Utf8StringSink utf8sinkB = new Utf8StringSink();
    private Rnd rnd;

    public RndVarcharFunction(int lo, int hi, int nullRate) {
        this.lo = lo;
        this.range = hi - lo + 1;
        this.nullRate = nullRate;
    }

    @Override
    public Utf8Sequence getVarcharA(Record rec) {
        if (this.rnd.nextInt() % this.nullRate == 1) {
            return null;
        }
        this.utf8sinkA.clear();
        this.sinkRnd(this.utf8sinkA);
        return this.utf8sinkA;
    }

    @Override
    public Utf8Sequence getVarcharB(Record rec) {
        if (this.rnd.nextInt() % this.nullRate == 1) {
            return null;
        }
        this.utf8sinkB.clear();
        this.sinkRnd(this.utf8sinkB);
        return this.utf8sinkB;
    }

    @Override
    public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) {
        this.rnd = executionContext.getRandom();
    }

    @Override
    public boolean isNonDeterministic() {
        return true;
    }

    @Override
    public boolean isRandom() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val("rnd_varchar(").val(this.lo).val(',').val(this.range + this.lo - 1).val(',').val(this.nullRate - 1).val(')');
    }

    private void sinkRnd(Utf8Sink utf8Sink) {
        int len = this.lo + this.rnd.nextPositiveInt() % this.range;
        if (this.rnd.nextBoolean()) {
            this.rnd.nextUtf8AsciiStr(len, utf8Sink);
        } else {
            this.rnd.nextUtf8Str(len, utf8Sink);
        }
    }
}

