/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.cairo.vm.Vm;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.cairo.vm.api.MemoryCARW;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.window.BasePartitionedWindowFunction;
import io.questdb.griffin.engine.functions.window.BaseWindowFunction;
import io.questdb.griffin.engine.window.WindowContext;
import io.questdb.griffin.engine.window.WindowFunction;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;

public class LeadLagWindowFunctionFactoryHelper {
    public static final ArrayColumnTypes LAG_COLUMN_TYPES = new ArrayColumnTypes();
    public static final String LAG_NAME = "lag";
    public static final String LEAD_NAME = "lead";

    static Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext, DefaultValueExtraChecker defaultValueExtraChecker, LagConstructor LagConstructor2, LagCurrentRowConstructor lagCurrentRowConstructor, LagOverPartitionConstructor lagOverPartitionConstructor) throws SqlException {
        WindowContext windowContext = sqlExecutionContext.getWindowContext();
        if (windowContext.isEmpty()) {
            throw SqlException.emptyWindowContext(position);
        }
        if (args.size() > 3) {
            throw SqlException.$(argPositions.getQuick(3), "too many arguments");
        }
        long offset = 1L;
        if (args.size() >= 2) {
            Function offsetFunc = args.getQuick(1);
            if (!offsetFunc.isConstant() && !offsetFunc.isRuntimeConstant()) {
                throw SqlException.$(argPositions.getQuick(1), "offset must be a constant");
            }
            offset = offsetFunc.getLong(null);
            if (offset < 0L) {
                throw SqlException.$(argPositions.getQuick(1), "offset must be a positive integer");
            }
        }
        Function defaultValue = null;
        if (args.size() == 3) {
            defaultValue = args.getQuick(2);
            if (defaultValue instanceof WindowFunction) {
                throw SqlException.$(argPositions.getQuick(2), "default value can not be a window function");
            }
            defaultValueExtraChecker.check(defaultValue);
        }
        if (offset == 0L) {
            return lagCurrentRowConstructor.newFunction(windowContext.getPartitionByRecord(), args.get(0), LAG_NAME, windowContext.isIgnoreNulls());
        }
        if (windowContext.getPartitionByRecord() != null) {
            Map map = MapFactory.createUnorderedMap(configuration, windowContext.getPartitionByKeyTypes(), LAG_COLUMN_TYPES);
            MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
            return lagOverPartitionConstructor.newFunction(map, windowContext.getPartitionByRecord(), windowContext.getPartitionBySink(), mem, args.get(0), windowContext.isIgnoreNulls(), defaultValue, offset);
        }
        MemoryCARW mem = Vm.getCARWInstance(configuration.getSqlWindowStorePageSize(), configuration.getSqlWindowStoreMaxPages(), 24);
        return LagConstructor2.newFunction(args.get(0), defaultValue, offset, mem, windowContext.isIgnoreNulls());
    }

    static {
        LAG_COLUMN_TYPES.add(6);
        LAG_COLUMN_TYPES.add(6);
        LAG_COLUMN_TYPES.add(6);
    }

    @FunctionalInterface
    static interface DefaultValueExtraChecker {
        public void check(Function var1) throws SqlException;
    }

    @FunctionalInterface
    static interface LagCurrentRowConstructor {
        public WindowFunction newFunction(VirtualRecord var1, Function var2, String var3, boolean var4);
    }

    @FunctionalInterface
    static interface LagOverPartitionConstructor {
        public WindowFunction newFunction(Map var1, VirtualRecord var2, RecordSink var3, MemoryARW var4, Function var5, boolean var6, Function var7, long var8);
    }

    @FunctionalInterface
    static interface LagConstructor {
        public WindowFunction newFunction(Function var1, Function var2, long var3, MemoryARW var5, boolean var6);
    }

    static abstract class BaseLeadOverPartitionFunction
    extends BasePartitionedWindowFunction {
        protected final Function defaultValue;
        protected final boolean ignoreNulls;
        protected final MemoryARW memory;
        protected final long offset;

        public BaseLeadOverPartitionFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, MemoryARW memory, Function arg, boolean ignoreNulls, Function defaultValue, long offset) {
            super(map, partitionByRecord, partitionBySink, arg);
            this.defaultValue = defaultValue;
            this.offset = offset;
            this.memory = memory;
            this.ignoreNulls = ignoreNulls;
        }

        @Override
        public void close() {
            super.close();
            Misc.free(this.memory);
        }

        @Override
        public String getName() {
            return LeadLagWindowFunctionFactoryHelper.LEAD_NAME;
        }

        @Override
        public WindowFunction.Pass1ScanDirection getPass1ScanDirection() {
            return WindowFunction.Pass1ScanDirection.BACKWARD;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            long firstIdx;
            long startOffset;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue mapValue = key.createValue();
            long count = 0L;
            if (mapValue.isNew()) {
                startOffset = this.memory.appendAddressFor(this.offset * 8L) - this.memory.getPageAddress(0);
                firstIdx = 0L;
            } else {
                startOffset = mapValue.getLong(0);
                firstIdx = mapValue.getLong(1);
                count = mapValue.getLong(2);
            }
            if (this.doPass1(count, this.offset, startOffset, firstIdx, record, recordOffset, spi)) {
                ++firstIdx;
                ++count;
            }
            mapValue.putLong(0, startOffset);
            mapValue.putLong(1, firstIdx % this.offset);
            mapValue.putLong(2, count);
        }

        @Override
        public void reset() {
            super.reset();
            Misc.free(this.memory);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(", ").val(this.offset).val(", ");
            if (this.defaultValue != null) {
                sink.val(this.defaultValue);
            } else {
                sink.val("NULL");
            }
            sink.val(')');
            if (this.ignoreNulls) {
                sink.val(" ignore nulls");
            }
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.memory.truncate();
        }

        protected abstract boolean doPass1(long var1, long var3, long var5, long var7, Record var9, long var10, WindowSPI var12);
    }

    static abstract class BaseLeadLagCurrentRow
    extends BaseWindowFunction {
        private final boolean ignoreNulls;
        private final String name;
        private final VirtualRecord partitionByRecord;

        public BaseLeadLagCurrentRow(VirtualRecord partitionByRecord, Function arg, String name, boolean ignoreNulls) {
            super(arg);
            this.partitionByRecord = partitionByRecord;
            this.name = name;
            this.ignoreNulls = ignoreNulls;
        }

        @Override
        public void close() {
            super.close();
            if (this.partitionByRecord != null) {
                Misc.freeObjList(this.partitionByRecord.getFunctions());
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(", ").val(0).val(", NULL)");
            if (this.ignoreNulls) {
                sink.val(" ignore nulls");
            }
            sink.val(" over ()");
        }
    }

    static abstract class BaseLeadFunction
    extends BaseWindowFunction
    implements Reopenable {
        protected final MemoryARW buffer;
        protected final Function defaultValue;
        protected final boolean ignoreNulls;
        protected final long offset;
        protected long count = 0L;
        protected int loIdx = 0;

        public BaseLeadFunction(Function arg, Function defaultValueFunc, long offset, MemoryARW memory, boolean ignoreNulls) {
            super(arg);
            this.offset = offset;
            this.buffer = memory;
            this.defaultValue = defaultValueFunc;
            this.ignoreNulls = ignoreNulls;
        }

        @Override
        public void close() {
            super.close();
            this.buffer.close();
        }

        @Override
        public String getName() {
            return LeadLagWindowFunctionFactoryHelper.LEAD_NAME;
        }

        @Override
        public WindowFunction.Pass1ScanDirection getPass1ScanDirection() {
            return WindowFunction.Pass1ScanDirection.BACKWARD;
        }

        @Override
        public void pass1(Record record, long recordOffset, WindowSPI spi) {
            if (this.doPass1(record, recordOffset, spi)) {
                this.loIdx = (int)((long)(this.loIdx + 1) % this.offset);
                ++this.count;
            }
        }

        @Override
        public void reopen() {
            this.loIdx = 0;
            this.count = 0L;
        }

        @Override
        public void reset() {
            super.reset();
            this.buffer.close();
            this.loIdx = 0;
            this.count = 0L;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(", ").val(this.offset).val(", ");
            if (this.defaultValue != null) {
                sink.val(this.defaultValue);
            } else {
                sink.val("NULL");
            }
            sink.val(')');
            if (this.ignoreNulls) {
                sink.val(" ignore nulls");
            }
            sink.val(" over ()");
        }

        @Override
        public void toTop() {
            super.toTop();
            this.loIdx = 0;
            this.count = 0L;
        }

        protected abstract boolean doPass1(Record var1, long var2, WindowSPI var4);
    }

    static abstract class BaseLagOverPartitionFunction
    extends BasePartitionedWindowFunction {
        protected final Function defaultValue;
        protected final boolean ignoreNulls;
        protected final MemoryARW memory;
        protected final long offset;

        public BaseLagOverPartitionFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, MemoryARW memory, Function arg, boolean ignoreNulls, Function defaultValue, long offset) {
            super(map, partitionByRecord, partitionBySink, arg);
            this.defaultValue = defaultValue;
            this.offset = offset;
            this.memory = memory;
            this.ignoreNulls = ignoreNulls;
        }

        @Override
        public void close() {
            super.close();
            Misc.free(this.memory);
        }

        @Override
        public void computeNext(Record record) {
            long firstIdx;
            long startOffset;
            this.partitionByRecord.of(record);
            MapKey key = this.map.withKey();
            key.put(this.partitionByRecord, this.partitionBySink);
            MapValue mapValue = key.createValue();
            long count = 0L;
            if (mapValue.isNew()) {
                startOffset = this.memory.appendAddressFor(this.offset * 8L) - this.memory.getPageAddress(0);
                firstIdx = 0L;
            } else {
                startOffset = mapValue.getLong(0);
                firstIdx = mapValue.getLong(1);
                count = mapValue.getLong(2);
            }
            if (this.computeNext0(count, this.offset, startOffset, firstIdx, record)) {
                ++firstIdx;
                ++count;
            }
            mapValue.putLong(0, startOffset);
            mapValue.putLong(1, firstIdx % this.offset);
            mapValue.putLong(2, count);
        }

        @Override
        public String getName() {
            return LeadLagWindowFunctionFactoryHelper.LAG_NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public boolean isIgnoreNulls() {
            return this.ignoreNulls;
        }

        @Override
        public void reset() {
            super.reset();
            Misc.free(this.memory);
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(", ").val(this.offset).val(", ");
            if (this.defaultValue != null) {
                sink.val(this.defaultValue);
            } else {
                sink.val("NULL");
            }
            sink.val(')');
            if (this.ignoreNulls) {
                sink.val(" ignore nulls");
            }
            sink.val(" over (");
            sink.val("partition by ");
            sink.val(this.partitionByRecord.getFunctions());
            sink.val(')');
        }

        @Override
        public void toTop() {
            super.toTop();
            this.memory.truncate();
        }

        protected abstract boolean computeNext0(long var1, long var3, long var5, long var7, Record var9);
    }

    static abstract class BaseLagFunction
    extends BaseWindowFunction
    implements Reopenable {
        protected final MemoryARW buffer;
        protected final Function defaultValue;
        protected final boolean ignoreNulls;
        protected final long offset;
        protected long count = 0L;
        protected int loIdx = 0;

        public BaseLagFunction(Function arg, Function defaultValueFunc, long offset, MemoryARW memory, boolean ignoreNulls) {
            super(arg);
            this.offset = offset;
            this.buffer = memory;
            this.defaultValue = defaultValueFunc;
            this.ignoreNulls = ignoreNulls;
        }

        @Override
        public void close() {
            super.close();
            this.buffer.close();
        }

        @Override
        public void computeNext(Record record) {
            if (this.computeNext0(record)) {
                this.loIdx = (int)((long)(this.loIdx + 1) % this.offset);
                ++this.count;
            }
        }

        @Override
        public String getName() {
            return LeadLagWindowFunctionFactoryHelper.LAG_NAME;
        }

        @Override
        public int getPassCount() {
            return 0;
        }

        @Override
        public boolean isIgnoreNulls() {
            return this.ignoreNulls;
        }

        @Override
        public void reopen() {
            this.loIdx = 0;
            this.count = 0L;
        }

        @Override
        public void reset() {
            super.reset();
            this.buffer.close();
            this.loIdx = 0;
            this.count = 0L;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.getName());
            sink.val('(').val(this.arg).val(", ").val(this.offset).val(", ");
            if (this.defaultValue != null) {
                sink.val(this.defaultValue);
            } else {
                sink.val("NULL");
            }
            sink.val(')');
            if (this.ignoreNulls) {
                sink.val(" ignore nulls");
            }
            sink.val(" over ()");
        }

        @Override
        public void toTop() {
            super.toTop();
            this.loIdx = 0;
            this.count = 0L;
        }

        protected abstract boolean computeNext0(Record var1);
    }
}

