/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ListColumnFilter;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.RecordSinkFactory;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.groupby.AbstractNoRecordSampleByCursor;
import io.questdb.griffin.engine.groupby.AbstractSampleByRecordCursorFactory;
import io.questdb.std.BytecodeAssembler;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractSampleByFillRecordCursorFactory
extends AbstractSampleByRecordCursorFactory {
    protected final ObjList<GroupByFunction> groupByFunctions;
    protected final Map map;
    protected final RecordSink mapSink;

    public AbstractSampleByFillRecordCursorFactory(@NotNull BytecodeAssembler asm, CairoConfiguration configuration, RecordCursorFactory base, @NotNull ListColumnFilter listColumnFilter, @NotNull ArrayColumnTypes keyTypes, @NotNull ArrayColumnTypes valueTypes, RecordMetadata groupByMetadata, ObjList<GroupByFunction> groupByFunctions, ObjList<Function> recordFunctions) {
        super(base, groupByMetadata, recordFunctions);
        try {
            this.groupByFunctions = groupByFunctions;
            this.mapSink = RecordSinkFactory.getInstance(asm, base.getMetadata(), listColumnFilter);
            this.map = MapFactory.createOrderedMap(configuration, keyTypes, valueTypes);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        AbstractNoRecordSampleByCursor cursor = null;
        try {
            cursor = this.getRawCursor();
            if (cursor instanceof Reopenable) {
                ((Reopenable)((Object)cursor)).reopen();
            }
        }
        catch (Throwable th) {
            Misc.free(cursor);
            throw th;
        }
        RecordCursor baseCursor = this.base.getCursor(executionContext);
        return this.initFunctionsAndCursor(executionContext, baseCursor);
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.getRawCursor());
    }
}

