/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.sql.AtomicBooleanCircuitBreaker;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cutlass.text.CopyContext;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.SingleValueRecordCursor;

public class CopyCancelFactory
extends AbstractRecordCursorFactory {
    private static final GenericRecordMetadata METADATA = new GenericRecordMetadata();
    private static final int STATUS_INDEX = 5;
    private final RecordCursorFactory baseFactory;
    private final long cancelCopyID;
    private final String cancelCopyIDStr;
    private final CopyContext copyContext;
    private final CopyCancelRecord record = new CopyCancelRecord();
    private final SingleValueRecordCursor cursor = new SingleValueRecordCursor(this.record);
    private CharSequence status;

    public CopyCancelFactory(CopyContext copyContext, long cancelCopyID, String cancelCopyIDStr, RecordCursorFactory baseFactory) {
        super(METADATA);
        this.copyContext = copyContext;
        this.cancelCopyID = cancelCopyID;
        this.cancelCopyIDStr = cancelCopyIDStr;
        this.baseFactory = baseFactory;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        AtomicBooleanCircuitBreaker circuitBreaker = this.copyContext.getCircuitBreaker();
        long activeCopyID = this.copyContext.getActiveCopyID();
        if (activeCopyID == this.cancelCopyID && this.cancelCopyID != -1L) {
            this.copyContext.getOriginatorSecurityContext().authorizeCopyCancel(executionContext.getSecurityContext());
            circuitBreaker.cancel();
            this.status = "cancelled";
        } else {
            try (RecordCursor c = this.baseFactory.getCursor(executionContext);){
                Record rec = c.getRecord();
                this.status = c.hasNext() ? rec.getSymA(5) : "unknown";
            }
        }
        this.cursor.toTop();
        return this.cursor;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Copy Cancel");
    }

    @Override
    protected void _close() {
        this.baseFactory.close();
        super._close();
    }

    static {
        METADATA.add(new TableColumnMetadata("id", 11));
        METADATA.add(new TableColumnMetadata("status", 11));
    }

    private class CopyCancelRecord
    implements Record {
        private CopyCancelRecord() {
        }

        @Override
        public CharSequence getStrA(int col) {
            switch (col) {
                case 0: {
                    return CopyCancelFactory.this.cancelCopyIDStr;
                }
                case 1: {
                    return CopyCancelFactory.this.status;
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

