/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.ops;

import io.questdb.cairo.ColumnType;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableToken;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.ops.CreateTableOperationBuilder;
import io.questdb.griffin.engine.ops.CreateTableOperationImpl;
import io.questdb.griffin.engine.table.ShowCreateTableRecordCursorFactory;
import io.questdb.griffin.model.CreateTableColumnModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.LowerCaseCharSequenceIntHashMap;
import io.questdb.std.LowerCaseCharSequenceObjHashMap;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateTableOperationBuilderImpl
implements CreateTableOperationBuilder,
Mutable,
Sinkable {
    public static final ObjectFactory<CreateTableOperationBuilderImpl> FACTORY = CreateTableOperationBuilderImpl::new;
    private static final IntList castGroups = new IntList();
    private final LowerCaseCharSequenceObjHashMap<CreateTableColumnModel> columnModels = new LowerCaseCharSequenceObjHashMap();
    private final LowerCaseCharSequenceIntHashMap columnNameIndexMap = new LowerCaseCharSequenceIntHashMap();
    private final ObjList<CharSequence> columnNames = new ObjList();
    private long batchO3MaxLag = -1L;
    private long batchSize = -1L;
    private int defaultSymbolCapacity;
    private boolean ignoreIfExists = false;
    private ExpressionNode likeTableNameExpr;
    private int maxUncommittedRows;
    private long o3MaxLag = -1L;
    private ExpressionNode partitionByExpr;
    private QueryModel selectModel;
    private CharSequence selectText;
    private int selectTextPosition;
    private ExpressionNode tableNameExpr;
    private ExpressionNode timestampExpr;
    private int ttlHoursOrMonths;
    private int ttlPosition;
    private CharSequence volumeAlias;
    private int volumePosition;
    private boolean walEnabled;

    public void addColumnModel(CharSequence columnName, CreateTableColumnModel model) throws SqlException {
        if (this.columnModels.get(columnName) != null) {
            throw SqlException.duplicateColumn(model.getColumnNamePos(), columnName);
        }
        this.columnNameIndexMap.put(columnName, this.columnModels.size());
        this.columnModels.put(columnName, model);
        this.columnNames.add(columnName);
    }

    @Override
    public CreateTableOperationImpl build(SqlCompiler compiler, SqlExecutionContext sqlExecutionContext, CharSequence sqlText) throws SqlException {
        if (this.selectText != null) {
            return new CreateTableOperationImpl(Chars.toString(sqlText), Chars.toString(this.tableNameExpr.token), this.tableNameExpr.position, Chars.toString(this.selectText), this.selectTextPosition, this.ignoreIfExists, this.getPartitionByFromExpr(), this.timestampExpr != null ? Chars.toString(this.timestampExpr.token) : null, this.timestampExpr != null ? this.timestampExpr.position : 0, Chars.toString(this.volumeAlias), this.volumePosition, this.ttlHoursOrMonths, this.ttlPosition, this.walEnabled, this.defaultSymbolCapacity, this.maxUncommittedRows, this.o3MaxLag, this.columnModels, this.batchSize, this.batchO3MaxLag);
        }
        if (this.likeTableNameExpr != null) {
            TableToken likeTableNameToken = compiler.getEngine().getTableTokenIfExists(this.likeTableNameExpr.token);
            if (likeTableNameToken == null) {
                throw SqlException.tableDoesNotExist(this.likeTableNameExpr.position, this.likeTableNameExpr.token);
            }
            return new CreateTableOperationImpl(Chars.toString(sqlText), Chars.toString(this.tableNameExpr.token), this.tableNameExpr.position, this.getPartitionByFromExpr(), Chars.toString(this.volumeAlias), this.volumePosition, likeTableNameToken.getTableName(), this.likeTableNameExpr.position, this.ignoreIfExists);
        }
        return new CreateTableOperationImpl(Chars.toString(sqlText), Chars.toString(this.tableNameExpr.token), this.tableNameExpr.position, this.getPartitionByFromExpr(), Chars.toString(this.volumeAlias), this.volumePosition, this.ignoreIfExists, this.columnNames, this.columnModels, this.getTimestampIndex(), this.o3MaxLag, this.maxUncommittedRows, this.ttlHoursOrMonths, this.ttlPosition, this.walEnabled);
    }

    @Override
    public void clear() {
        this.columnNameIndexMap.clear();
        this.columnNames.clear();
        this.columnModels.clear();
        this.batchO3MaxLag = -1L;
        this.batchSize = -1L;
        this.defaultSymbolCapacity = 0;
        this.ignoreIfExists = false;
        this.likeTableNameExpr = null;
        this.maxUncommittedRows = 0;
        this.o3MaxLag = -1L;
        this.partitionByExpr = null;
        this.tableNameExpr = null;
        this.timestampExpr = null;
        this.selectText = null;
        this.selectTextPosition = 0;
        this.selectModel = null;
        this.volumeAlias = null;
        this.volumePosition = 0;
        this.ttlHoursOrMonths = 0;
        this.ttlPosition = 0;
        this.walEnabled = false;
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public int getColumnIndex(CharSequence columnName) {
        return this.columnNameIndexMap.get(columnName);
    }

    @Nullable
    public CreateTableColumnModel getColumnModel(CharSequence columnName) {
        return this.columnModels.get(columnName);
    }

    public CharSequence getColumnName(int index) {
        return this.columnNames.get(index);
    }

    public int getPartitionByFromExpr() {
        return this.partitionByExpr == null ? 3 : PartitionBy.fromString(this.partitionByExpr.token);
    }

    @Override
    public QueryModel getQueryModel() {
        return this.selectModel;
    }

    public CharSequence getSelectText() {
        return this.selectText;
    }

    @Override
    public CharSequence getTableName() {
        return this.tableNameExpr.token;
    }

    @Override
    public ExpressionNode getTableNameExpr() {
        return this.tableNameExpr;
    }

    public ExpressionNode getTimestampExpr() {
        return this.timestampExpr;
    }

    public int getTimestampIndex() {
        return this.timestampExpr != null ? this.getColumnIndex(this.timestampExpr.token) : -1;
    }

    public int getTtlHoursOrMonths() {
        return this.ttlHoursOrMonths;
    }

    public CharSequence getVolumeAlias() {
        return this.volumeAlias;
    }

    public boolean isAtomic() {
        return this.batchSize == -1L;
    }

    public boolean isWalEnabled() {
        return this.walEnabled;
    }

    public void setBatchO3MaxLag(long batchO3MaxLag) {
        this.batchO3MaxLag = batchO3MaxLag;
    }

    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
    }

    public void setDefaultSymbolCapacity(int defaultSymbolCapacity) {
        this.defaultSymbolCapacity = defaultSymbolCapacity;
    }

    public void setIgnoreIfExists(boolean flag) {
        this.ignoreIfExists = flag;
    }

    public void setLikeTableNameExpr(ExpressionNode expr) {
        this.likeTableNameExpr = expr;
    }

    public void setMaxUncommittedRows(int maxUncommittedRows) {
        this.maxUncommittedRows = maxUncommittedRows;
    }

    public void setO3MaxLag(long o3MaxLag) {
        this.o3MaxLag = o3MaxLag;
    }

    public void setPartitionByExpr(ExpressionNode partitionByExpr) {
        this.partitionByExpr = partitionByExpr;
    }

    @Override
    public void setSelectModel(QueryModel selectModel) {
        this.selectModel = selectModel;
    }

    public void setSelectText(CharSequence selectText, int selectTextPosition) {
        this.selectText = selectText;
        this.selectTextPosition = selectTextPosition;
    }

    public void setTableNameExpr(ExpressionNode expr) {
        this.tableNameExpr = expr;
    }

    public void setTimestampExpr(ExpressionNode expr) {
        this.timestampExpr = expr;
    }

    public void setTtlHoursOrMonths(int ttlHoursOrMonths) {
        this.ttlHoursOrMonths = ttlHoursOrMonths;
    }

    public void setTtlPosition(int ttlPosition) {
        this.ttlPosition = ttlPosition;
    }

    public void setVolumeAlias(CharSequence volumeAlias, int volumePosition) {
        this.volumeAlias = Chars.toString(volumeAlias);
        this.volumePosition = volumePosition;
    }

    public void setWalEnabled(boolean walEnabled) {
        this.walEnabled = walEnabled;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.putAscii("create");
        if (!this.isAtomic()) {
            sink.putAscii(" batch ");
            sink.put(this.batchSize);
            if (this.batchO3MaxLag != -1L) {
                sink.putAscii(" o3MaxLag ");
                sink.put(this.batchO3MaxLag);
            }
        } else {
            sink.putAscii(" atomic");
        }
        sink.putAscii(" table ");
        sink.put(this.getTableNameExpr().token);
        if (this.selectModel != null) {
            sink.putAscii(" as (");
            this.selectModel.toSink(sink);
            sink.putAscii(')');
            ObjList castColumns = this.columnModels.keys();
            int n = castColumns.size();
            for (int i = 0; i < n; ++i) {
                CharSequence column = (CharSequence)castColumns.getQuick(i);
                CreateTableColumnModel model = this.columnModels.get(column);
                int type = model.getColumnType();
                if (type > 0) {
                    sink.putAscii(", cast(");
                    sink.put(column);
                    sink.putAscii(" as ");
                    sink.put(ColumnType.nameOf(type));
                    sink.putAscii(':');
                    sink.put(model.getColumnTypePos());
                    if (ColumnType.isSymbol(type)) {
                        CreateTableOperationBuilderImpl.symbolClauseToSink(sink, model);
                    }
                } else if (model.isIndexed()) {
                    sink.putAscii(", index(").put(column);
                    sink.putAscii(" capacity ");
                    sink.put(model.getIndexValueBlockSize());
                }
                sink.putAscii(')');
            }
        } else {
            sink.putAscii(" (");
            if (this.likeTableNameExpr != null) {
                sink.putAscii("like ");
                sink.put(this.likeTableNameExpr.token);
            } else {
                int count = this.columnNames.size();
                for (int i = 0; i < count; ++i) {
                    if (i > 0) {
                        sink.putAscii(", ");
                    }
                    CharSequence columnName = this.columnNames.getQuick(i);
                    CreateTableColumnModel model = this.columnModels.get(columnName);
                    sink.put(columnName);
                    sink.putAscii(' ');
                    sink.put(ColumnType.nameOf(model.getColumnType()));
                    if (!ColumnType.isSymbol(model.getColumnType())) continue;
                    CreateTableOperationBuilderImpl.symbolClauseToSink(sink, model);
                }
            }
            sink.putAscii(')');
        }
        if (this.getTimestampExpr() != null) {
            sink.putAscii(" timestamp(");
            sink.put(this.getTimestampExpr().token);
            sink.putAscii(')');
        }
        if (this.partitionByExpr != null) {
            sink.putAscii(" partition by ").put(this.partitionByExpr.token);
            if (this.walEnabled) {
                sink.putAscii(" wal");
            }
        }
        ShowCreateTableRecordCursorFactory.ttlToSink(this.ttlHoursOrMonths, sink);
        if (this.volumeAlias != null) {
            sink.putAscii(" in volume '").put(this.volumeAlias).putAscii('\'');
        }
    }

    private static boolean isIPv4Cast(int from, int to) {
        return from == 11 && to == 25 || from == 26 && to == 25;
    }

    private static void symbolClauseToSink(@NotNull CharSink<?> sink, CreateTableColumnModel model) {
        sink.putAscii(" capacity ");
        sink.put(model.getSymbolCapacity());
        if (model.getSymbolCacheFlag()) {
            sink.putAscii(" cache");
        } else {
            sink.putAscii(" nocache");
        }
        if (model.isIndexed()) {
            sink.putAscii(" index capacity ");
            sink.put(model.getIndexValueBlockSize());
        }
    }

    static boolean isCompatibleCast(int from, int to) {
        if (from == to || CreateTableOperationBuilderImpl.isIPv4Cast(from, to)) {
            return true;
        }
        return castGroups.getQuick(ColumnType.tagOf(from)) == castGroups.getQuick(ColumnType.tagOf(to));
    }

    static {
        castGroups.extendAndSet(1, 2);
        castGroups.extendAndSet(2, 1);
        castGroups.extendAndSet(3, 1);
        castGroups.extendAndSet(4, 1);
        castGroups.extendAndSet(5, 1);
        castGroups.extendAndSet(6, 1);
        castGroups.extendAndSet(9, 1);
        castGroups.extendAndSet(10, 1);
        castGroups.extendAndSet(7, 1);
        castGroups.extendAndSet(8, 1);
        castGroups.extendAndSet(11, 3);
        castGroups.extendAndSet(26, 3);
        castGroups.extendAndSet(12, 3);
        castGroups.extendAndSet(18, 4);
    }
}

