/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.DataUnavailableException;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.engine.table.SelectedRecord;
import io.questdb.std.IntList;
import io.questdb.std.Misc;

class SelectedRecordCursor
implements RecordCursor {
    private final IntList columnCrossIndex;
    private final SelectedRecord recordA;
    private final SelectedRecord recordB;
    private RecordCursor baseCursor;

    public SelectedRecordCursor(IntList columnCrossIndex, boolean supportsRandomAccess) {
        this.recordA = new SelectedRecord(columnCrossIndex);
        this.recordB = supportsRandomAccess ? new SelectedRecord(columnCrossIndex) : null;
        this.columnCrossIndex = columnCrossIndex;
    }

    @Override
    public void calculateSize(SqlExecutionCircuitBreaker circuitBreaker, RecordCursor.Counter counter) {
        this.baseCursor.calculateSize(circuitBreaker, counter);
    }

    @Override
    public void close() {
        this.baseCursor = Misc.free(this.baseCursor);
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public Record getRecordB() {
        if (this.recordB != null) {
            return this.recordB;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.baseCursor.getSymbolTable(this.columnCrossIndex.getQuick(columnIndex));
    }

    @Override
    public boolean hasNext() {
        return this.baseCursor.hasNext();
    }

    @Override
    public SymbolTable newSymbolTable(int columnIndex) {
        return this.baseCursor.newSymbolTable(this.columnCrossIndex.getQuick(columnIndex));
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.baseCursor.recordAt(((SelectedRecord)record).getBaseRecord(), atRowId);
    }

    @Override
    public long size() {
        return this.baseCursor.size();
    }

    @Override
    public void skipRows(RecordCursor.Counter rowCount) throws DataUnavailableException {
        this.baseCursor.skipRows(rowCount);
    }

    @Override
    public void toTop() {
        this.baseCursor.toTop();
    }

    @Override
    public long preComputedStateSize() {
        return this.baseCursor.preComputedStateSize();
    }

    void of(RecordCursor cursor) {
        this.baseCursor = cursor;
        this.recordA.of(cursor.getRecord());
        if (this.recordB != null) {
            this.recordB.of(cursor.getRecordB());
        }
    }
}

