/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoTable;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.MetadataCacheReader;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.file.BlockFileReader;
import io.questdb.cairo.mv.MatViewDefinition;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.TableReferenceOutOfDateException;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.ShowCreateTableRecordCursorFactory;
import io.questdb.std.Misc;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8StringSink;
import org.jetbrains.annotations.NotNull;

public class ShowCreateMatViewRecordCursorFactory
extends AbstractRecordCursorFactory {
    public static final int N_DDL_COL = 0;
    private static final RecordMetadata METADATA;
    protected final TableToken tableToken;
    protected final int tokenPosition;
    private final ShowCreateMatViewCursor cursor = new ShowCreateMatViewCursor();

    public ShowCreateMatViewRecordCursorFactory(TableToken tableToken, int tokenPosition) {
        super(METADATA);
        this.tableToken = tableToken;
        this.tokenPosition = tokenPosition;
    }

    @Override
    public RecordCursor getCursor(SqlExecutionContext executionContext) throws SqlException {
        return this.cursor.of(executionContext, this.tableToken, this.tokenPosition);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return false;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("show_create_materialized_view");
        sink.meta("of").val(this.tableToken.getTableName());
    }

    @Override
    protected void _close() {
        super._close();
        Misc.free(this.cursor);
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("ddl", 26));
        METADATA = metadata;
    }

    public static class ShowCreateMatViewCursor
    implements NoRandomAccessRecordCursor {
        protected final Utf8StringSink sink = new Utf8StringSink();
        protected final MatViewDefinition viewDefinition = new MatViewDefinition();
        private final Path path;
        private final ShowCreateMatViewRecord record = new ShowCreateMatViewRecord();
        protected SqlExecutionContext executionContext;
        protected CairoTable table;
        private boolean hasRun;
        private BlockFileReader reader;
        private TableToken tableToken;

        public ShowCreateMatViewCursor() {
            this.path = new Path();
        }

        @Override
        public void close() {
            this.sink.clear();
            this.viewDefinition.clear();
            Misc.free(this.path);
            Misc.free(this.reader);
        }

        @Override
        public Record getRecord() {
            return this.record;
        }

        @Override
        public boolean hasNext() {
            if (!this.hasRun) {
                this.sink.clear();
                CairoConfiguration config = this.executionContext.getCairoEngine().getConfiguration();
                this.showCreateMatView(config);
                this.hasRun = true;
                return true;
            }
            return false;
        }

        public ShowCreateMatViewCursor of(SqlExecutionContext executionContext, TableToken tableToken, int tokenPosition) throws SqlException {
            this.tableToken = tableToken;
            this.executionContext = executionContext;
            try (MetadataCacheReader metadataRO = executionContext.getCairoEngine().getMetadataCache().readLock();){
                this.table = metadataRO.getTable(tableToken);
                if (this.table == null) {
                    throw SqlException.$(tokenPosition, "table does not exist [table=").put(tableToken.getTableName()).put(']');
                }
                if (!tableToken.equals(this.table.getTableToken())) {
                    throw TableReferenceOutOfDateException.of(tableToken);
                }
            }
            if (!tableToken.isMatView()) {
                throw SqlException.$(tokenPosition, "materialized view expected, got table");
            }
            CairoConfiguration configuration = executionContext.getCairoEngine().getConfiguration();
            this.path.of(configuration.getDbRoot());
            int pathLen = this.path.size();
            if (this.reader == null) {
                this.reader = new BlockFileReader(configuration);
            }
            try {
                MatViewDefinition.readFrom(this.viewDefinition, this.reader, this.path, pathLen, tableToken);
            }
            catch (CairoException e) {
                throw SqlException.$(tokenPosition, "could not read materialized view definition [table=").put(tableToken).put(", msg=").put(e).put(']');
            }
            finally {
                this.reader.close();
            }
            this.toTop();
            return this;
        }

        @Override
        public long preComputedStateSize() {
            return 0L;
        }

        @Override
        public long size() {
            return -1L;
        }

        @Override
        public void toTop() {
            this.sink.clear();
            this.hasRun = false;
        }

        private void showCreateMatView(CairoConfiguration configuration) {
            this.sink.putAscii("CREATE MATERIALIZED VIEW '").put(this.tableToken.getTableName()).putAscii("' WITH BASE '").put(this.viewDefinition.getBaseTableName());
            this.sink.putAscii("' REFRESH");
            if (this.viewDefinition.getRefreshType() == 1) {
                this.sink.putAscii(" EVERY ");
                this.sink.put(this.viewDefinition.getTimerInterval());
                this.sink.putAscii(this.viewDefinition.getTimerUnit());
                if (this.viewDefinition.isDeferred()) {
                    this.sink.putAscii(" DEFERRED");
                }
                if (this.viewDefinition.getPeriodLength() == 0) {
                    this.sink.putAscii(" START '");
                    this.sink.putISODate(this.viewDefinition.getTimerStart());
                    if (this.viewDefinition.getTimerTimeZone() != null) {
                        this.sink.putAscii("' TIME ZONE '");
                        this.sink.put(this.viewDefinition.getTimerTimeZone());
                    }
                    this.sink.putAscii('\'');
                }
            } else if (this.viewDefinition.getRefreshType() == 0) {
                this.sink.putAscii(" IMMEDIATE");
                if (this.viewDefinition.isDeferred()) {
                    this.sink.putAscii(" DEFERRED");
                }
            } else if (this.viewDefinition.getRefreshType() == 2) {
                this.sink.putAscii(" MANUAL");
                if (this.viewDefinition.isDeferred()) {
                    this.sink.putAscii(" DEFERRED");
                }
            }
            if (this.viewDefinition.getPeriodLength() > 0) {
                this.sink.putAscii(" PERIOD (LENGTH ");
                this.sink.put(this.viewDefinition.getPeriodLength());
                this.sink.putAscii(this.viewDefinition.getPeriodLengthUnit());
                if (this.viewDefinition.getTimerTimeZone() != null) {
                    this.sink.putAscii(" TIME ZONE '");
                    this.sink.put(this.viewDefinition.getTimerTimeZone());
                    this.sink.putAscii('\'');
                }
                if (this.viewDefinition.getPeriodDelay() > 0) {
                    this.sink.putAscii(" DELAY ");
                    this.sink.put(this.viewDefinition.getPeriodDelay());
                    this.sink.putAscii(this.viewDefinition.getPeriodDelayUnit());
                }
                this.sink.putAscii(')');
            }
            this.sink.putAscii(" AS (\n").put(this.viewDefinition.getMatViewSql()).putAscii('\n');
            this.sink.putAscii(") PARTITION BY ").put(this.table.getPartitionByName());
            ShowCreateTableRecordCursorFactory.ttlToSink(this.table.getTtlHoursOrMonths(), this.sink);
            ShowCreateTableRecordCursorFactory.inVolumeToSink(configuration, this.table, this.sink);
            this.putAdditional();
            this.sink.putAscii(';');
        }

        protected void putAdditional() {
        }

        public class ShowCreateMatViewRecord
        implements Record {
            @Override
            @NotNull
            public Utf8Sequence getVarcharA(int col) {
                if (col == 0) {
                    return ShowCreateMatViewCursor.this.sink;
                }
                throw new UnsupportedOperationException();
            }

            @Override
            public Utf8Sequence getVarcharB(int col) {
                return this.getVarcharA(col);
            }

            @Override
            public int getVarcharSize(int col) {
                return this.getVarcharA(col).size();
            }
        }
    }
}

